"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RULE_NAME = exports.OS_LABEL = exports.NAME_LABEL = exports.NAME_ERROR = exports.EventFiltersList = exports.EventFiltersCardDecorator = exports.DESCRIPTION_LABEL = exports.ABOUT_EVENT_FILTERS = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _user_privileges = require("../../../../common/components/user_privileges");
var _kibana = require("../../../../common/lib/kibana");
var _artifact_list_page = require("../../../components/artifact_list_page");
var _api_client = require("../service/api_client");
var _form = require("./components/form");
var _constants = require("../constants");
var _process_descendants_indicator = require("../../../components/artifact_entry_card/components/card_decorators/process_descendants_indicator");
var _translations = require("./translations");
var _artifacts = require("../../../../../common/endpoint/service/artifacts");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/event_filters/view/event_filters_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ABOUT_EVENT_FILTERS = exports.ABOUT_EVENT_FILTERS = _i18n.i18n.translate('xpack.securitySolution.eventFilters.aboutInfo', {
  defaultMessage: 'Event filters exclude high volume or unwanted events from being written to Elasticsearch.'
});
const NAME_LABEL = exports.NAME_LABEL = _i18n.i18n.translate('xpack.securitySolution.eventFilter.form.name.label', {
  defaultMessage: 'Name'
});
const DESCRIPTION_LABEL = exports.DESCRIPTION_LABEL = _i18n.i18n.translate('xpack.securitySolution.eventFilter.form.description.placeholder', {
  defaultMessage: 'Description'
});
const NAME_ERROR = exports.NAME_ERROR = _i18n.i18n.translate('xpack.securitySolution.eventFilter.form.name.error', {
  defaultMessage: "The name can't be empty"
});
const OS_LABEL = exports.OS_LABEL = _i18n.i18n.translate('xpack.securitySolution.eventFilter.form.os.label', {
  defaultMessage: 'Select operating system'
});
const RULE_NAME = exports.RULE_NAME = _i18n.i18n.translate('xpack.securitySolution.eventFilter.form.rule.name', {
  defaultMessage: 'Endpoint Event Filtering'
});
const EVENT_FILTERS_PAGE_LABELS = {
  pageTitle: _i18n.i18n.translate('xpack.securitySolution.eventFilters.pageTitle', {
    defaultMessage: 'Event Filters'
  }),
  pageAboutInfo: _i18n.i18n.translate('xpack.securitySolution.eventFilters.pageAboutInfo', {
    defaultMessage: 'Event filters exclude high volume or unwanted events from being written to Elasticsearch.'
  }),
  pageAddButtonTitle: _i18n.i18n.translate('xpack.securitySolution.eventFilters.pageAddButtonTitle', {
    defaultMessage: 'Add event filter'
  }),
  getShowingCountLabel: total => _i18n.i18n.translate('xpack.securitySolution.eventFilters.showingTotal', {
    defaultMessage: 'Showing {total} {total, plural, one {event filter} other {event filters}}',
    values: {
      total
    }
  }),
  cardActionEditLabel: _i18n.i18n.translate('xpack.securitySolution.eventFilters.cardActionEditLabel', {
    defaultMessage: 'Edit event filter'
  }),
  cardActionDeleteLabel: _i18n.i18n.translate('xpack.securitySolution.eventFilters.cardActionDeleteLabel', {
    defaultMessage: 'Delete event filter'
  }),
  flyoutCreateTitle: _i18n.i18n.translate('xpack.securitySolution.eventFilters.flyoutCreateTitle', {
    defaultMessage: 'Add event filter'
  }),
  flyoutEditTitle: _i18n.i18n.translate('xpack.securitySolution.eventFilters.flyoutEditTitle', {
    defaultMessage: 'Edit event filter'
  }),
  flyoutCreateSubmitButtonLabel: _i18n.i18n.translate('xpack.securitySolution.eventFilters.flyoutCreateSubmitButtonLabel', {
    defaultMessage: 'Add event filter'
  }),
  flyoutCreateSubmitSuccess: ({
    name
  }) => _i18n.i18n.translate('xpack.securitySolution.eventFilters.flyoutCreateSubmitSuccess', {
    defaultMessage: '"{name}" has been added to the event filters list.',
    values: {
      name
    }
  }),
  flyoutEditSubmitSuccess: ({
    name
  }) => _i18n.i18n.translate('xpack.securitySolution.eventFilters.flyoutEditSubmitSuccess', {
    defaultMessage: '"{name}" has been updated.',
    values: {
      name
    }
  }),
  flyoutDowngradedLicenseDocsInfo: securitySolutionDocsLinks => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.eventFilters.flyoutDowngradedLicenseDocsInfo",
      defaultMessage: "For more information, see our ",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      target: "_blank",
      href: `${securitySolutionDocsLinks.eventFilters}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 107,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.eventFilters.flyoutDowngradedLicenseDocsLink",
      defaultMessage: "Event filters documentation",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 11
      }
    })));
  },
  deleteActionSuccess: itemName => _i18n.i18n.translate('xpack.securitySolution.eventFilters.deleteSuccess', {
    defaultMessage: '"{itemName}" has been removed from event filters list.',
    values: {
      itemName
    }
  }),
  emptyStateTitleNoEntries: _i18n.i18n.translate('xpack.securitySolution.eventFilters.emptyStateTitleNoEntries', {
    defaultMessage: 'There are no event filters to display.'
  }),
  emptyStateTitle: _i18n.i18n.translate('xpack.securitySolution.eventFilters.emptyStateTitle', {
    defaultMessage: 'Add your first event filter'
  }),
  emptyStateInfo: _i18n.i18n.translate('xpack.securitySolution.eventFilters.emptyStateInfo', {
    defaultMessage: 'Add an event filter to exclude high volume or unwanted events from being written to Elasticsearch.'
  }),
  emptyStatePrimaryButtonLabel: _i18n.i18n.translate('xpack.securitySolution.eventFilters.emptyStatePrimaryButtonLabel', {
    defaultMessage: 'Add event filter'
  }),
  searchPlaceholderInfo: _i18n.i18n.translate('xpack.securitySolution.eventFilters.searchPlaceholderInfo', {
    defaultMessage: 'Search on the fields below: name, description, comments, value'
  })
};
const EventFiltersCardDecorator = exports.EventFiltersCardDecorator = /*#__PURE__*/(0, _react.memo)(({
  item,
  'data-test-subj': dataTestSubj
}) => {
  return /*#__PURE__*/_react.default.createElement(_process_descendants_indicator.ProcessDescendantsIndicator, {
    item: item,
    "data-test-subj": dataTestSubj,
    labels: _translations.EVENT_FILTERS_PROCESS_DESCENDANT_DECORATOR_LABELS,
    processDescendantsTag: _artifacts.FILTER_PROCESS_DESCENDANTS_TAG,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 7
    }
  });
});
EventFiltersCardDecorator.displayName = 'EventFiltersCardDecorator';
const EventFiltersList = exports.EventFiltersList = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    canWriteEventFilters
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const http = (0, _kibana.useHttp)();
  const eventFiltersApiClient = _api_client.EventFiltersApiClient.getInstance(http);
  return /*#__PURE__*/_react.default.createElement(_artifact_list_page.ArtifactListPage, {
    apiClient: eventFiltersApiClient,
    ArtifactFormComponent: _form.EventFiltersForm,
    labels: EVENT_FILTERS_PAGE_LABELS,
    "data-test-subj": "EventFiltersListPage",
    searchableFields: _constants.SEARCHABLE_FIELDS,
    flyoutSize: "l",
    allowCardCreateAction: canWriteEventFilters,
    allowCardEditAction: canWriteEventFilters,
    allowCardDeleteAction: canWriteEventFilters,
    CardDecorator: EventFiltersCardDecorator,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 5
    }
  });
});
EventFiltersList.displayName = 'EventFiltersList';