"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointExceptionsFlyout = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _securitysolutionListConstants = require("@kbn/securitysolution-list-constants");
var _helpers = require("../../../../../detection_engine/rule_exceptions/components/add_exception_flyout/helpers");
var _use_close_alerts = require("../../../../../detection_engine/rule_exceptions/logic/use_close_alerts");
var _alerts_actions = require("../../../../../detection_engine/rule_exceptions/components/flyout_components/alerts_actions");
var _artifact_flyout = require("../../../../components/artifact_list_page/components/artifact_flyout");
var _artifact_confirm_modal = require("../../../../components/artifact_list_page/components/artifact_confirm_modal");
var _artifacts = require("../../../../hooks/artifacts");
var _kibana = require("../../../../../common/lib/kibana");
var _helpers2 = require("../../../../../detection_engine/rule_exceptions/utils/helpers");
var _endpoint_exceptions_form = require("./endpoint_exceptions_form");
var _api_client = require("../../service/api_client");
var _translations = require("../../translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/endpoint_exceptions/view/components/endpoint_exceptions_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EndpointExceptionsFlyout = ({
  onCancel,
  onConfirm,
  alertData,
  alertStatus,
  isAlertDataLoading,
  rules
}) => {
  const endpointExceptionsFlyoutTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'endpointExceptionsCreateFlyoutTitle'
  });
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const maskProps = (0, _react.useMemo)(() => ({
    style: `z-index: ${euiTheme.levels.flyout + 4}`
  }),
  // we need this flyout to be above the timeline flyout (which has a z-index of 1003)
  [euiTheme.levels.flyout]);
  const toasts = (0, _kibana.useToasts)();
  const http = (0, _kibana.useHttp)();
  const {
    isLoading: isSubmittingData,
    mutateAsync: submitData
  } = (0, _artifacts.useCreateArtifact)(_api_client.EndpointExceptionsApiClient.getInstance(http));
  const [isClosingAlerts, closeAlerts] = (0, _use_close_alerts.useCloseAlertsFromExceptions)();
  const [exception, setException] = (0, _react.useState)();
  const exceptionArrayWrapper = (0, _react.useMemo)(() => exception ? [exception] : [], [exception]);
  const [isFormValid, setIsFormValid] = (0, _react.useState)(false);
  const [showConfirmModal, setShowConfirmModal] = (0, _react.useState)(false);
  const [confirmModalLabels, setConfirmModalLabels] = (0, _react.useState)();
  const [closeSingleAlert, setCloseSingleAlert] = (0, _react.useState)(false);
  const [bulkCloseAlerts, setBulkCloseAlerts] = (0, _react.useState)(false);
  const [disableBulkClose, setDisableBulkCloseAlerts] = (0, _react.useState)(false);
  const [bulkCloseIndex, setBulkCloseIndex] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    if (!isAlertDataLoading && alertData) {
      const initialException = {
        ...(0, _helpers2.defaultEndpointExceptionItems)(_securitysolutionListConstants.ENDPOINT_ARTIFACT_LISTS.endpointExceptions.id, '', alertData)[0],
        os_types: (0, _helpers2.retrieveAlertOsTypes)(alertData)
      };
      setException(initialException);
    }
  }, [alertData, isAlertDataLoading]);
  const handleCloseFlyout = (0, _react.useCallback)(() => {
    onCancel(false);
  }, [onCancel]);
  const handleOnChange = (0, _react.useCallback)(formState => {
    if (!formState) return;
    setIsFormValid(formState.isValid);
    setException(formState.item);
    setConfirmModalLabels(formState.confirmModalLabels);
  }, []);
  const submitException = (0, _react.useCallback)(async () => {
    try {
      const addedException = await submitData(exception);
      const {
        shouldCloseAlerts,
        alertIdToClose,
        ruleStaticIds
      } = (0, _helpers.prepareToCloseAlerts)({
        alertData,
        closeSingleAlert,
        addToRules: false,
        rules,
        bulkCloseAlerts,
        selectedRulesToAddTo: []
      });
      if (closeAlerts != null && shouldCloseAlerts) {
        await closeAlerts(ruleStaticIds, [addedException], alertIdToClose, bulkCloseIndex);
      }
      toasts.addSuccess(_translations.ENDPOINT_EXCEPTIONS_PAGE_LABELS.flyoutCreateSubmitSuccess(addedException));
      onConfirm(true, closeSingleAlert, bulkCloseAlerts);
    } catch (error) {
      toasts.addError(error, (0, _translations.getCreationErrorMessage)(error));
    }
  }, [alertData, bulkCloseAlerts, bulkCloseIndex, closeAlerts, closeSingleAlert, exception, onConfirm, rules, submitData, toasts]);
  const handleOnSubmit = (0, _react.useCallback)(() => {
    if (confirmModalLabels) {
      setShowConfirmModal(true);
    } else {
      return submitException();
    }
  }, [confirmModalLabels, submitException]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    size: "l",
    onClose: handleCloseFlyout,
    "aria-labelledby": endpointExceptionsFlyoutTitleId,
    "data-test-subj": "addEndpointExceptionFlyout",
    maskProps: maskProps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: endpointExceptionsFlyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 11
    }
  }, _translations.ENDPOINT_EXCEPTIONS_PAGE_LABELS.flyoutCreateTitle))), isFormValid, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 7
    }
  }, exception && /*#__PURE__*/_react.default.createElement(_endpoint_exceptions_form.EndpointExceptionsForm, {
    allowSelectOs: !alertData,
    error: undefined,
    disabled: false,
    item: exception,
    mode: "create",
    onChange: handleOnChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_alerts_actions.ExceptionItemsFlyoutAlertsActions, {
    exceptionListType: "endpoint",
    shouldCloseSingleAlert: closeSingleAlert,
    onSingleAlertCloseCheckboxChange: setCloseSingleAlert,
    shouldBulkCloseAlert: bulkCloseAlerts,
    onBulkCloseCheckboxChange: setBulkCloseAlerts,
    disableBulkClose: disableBulkClose,
    onDisableBulkClose: setDisableBulkCloseAlerts,
    exceptionListItems: exceptionArrayWrapper,
    onUpdateBulkCloseIndex: setBulkCloseIndex,
    alertData: alertData,
    isAlertDataLoading: isAlertDataLoading !== null && isAlertDataLoading !== void 0 ? isAlertDataLoading : false,
    alertStatus: alertStatus,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    css: (0, _react2.css)`
            padding: ${euiTheme.size.s};
          `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "add-endpoint-exception-cancel-button",
    onClick: handleCloseFlyout,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 11
    }
  }, _artifact_flyout.ARTIFACT_FLYOUT_LABELS.flyoutCancelButtonLabel), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "add-endpoint-exception-confirm-button",
    fill: true,
    disabled: isAlertDataLoading || !isFormValid || isSubmittingData || isClosingAlerts,
    onClick: handleOnSubmit,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 11
    }
  }, _translations.ENDPOINT_EXCEPTIONS_PAGE_LABELS.flyoutCreateSubmitButtonLabel))), showConfirmModal && confirmModalLabels && /*#__PURE__*/_react.default.createElement(_artifact_confirm_modal.ArtifactConfirmModal, (0, _extends2.default)({}, confirmModalLabels, {
    onSuccess: submitException,
    onCancel: () => setShowConfirmModal(false),
    "data-test-subj": "endpointExceptionConfirmModal",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 9
    }
  })));
};
exports.EndpointExceptionsFlyout = EndpointExceptionsFlyout;
EndpointExceptionsFlyout.displayName = 'EndpointExceptionsFlyout';