"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.links = exports.getManagementFilteredLinks = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("@kbn/security-solution-features/constants");
var _check_artifact_has_data = require("./services/exceptions_list/check_artifact_has_data");
var _authz = require("../../common/endpoint/service/authz");
var _constants2 = require("../../common/constants");
var _translations = require("../app/translations");
var _use_license = require("../common/hooks/use_license");
var _links = require("../notes/links");
var _response_action_history = require("../common/icons/response_action_history");
var _blocklist = require("../common/icons/blocklist");
var _endpoints = require("../common/icons/endpoints");
var _policies = require("../common/icons/policies");
var _event_filters = require("../common/icons/event_filters");
var _host_isolation_exceptions = require("../common/icons/host_isolation_exceptions");
var _trusted_applications = require("../common/icons/trusted_applications");
var _entity_analytics = require("../common/icons/entity_analytics");
var _host_isolation_exceptions_api_client = require("./pages/host_isolation_exceptions/host_isolation_exceptions_api_client");
var _asset_criticality = require("../common/icons/asset_criticality");
var _trusted_devices = require("../common/icons/trusted_devices");
var _endpoint_exceptions = require("../common/icons/endpoint_exceptions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const categories = [{
  label: _i18n.i18n.translate('xpack.securitySolution.appLinks.category.entityAnalytics', {
    defaultMessage: 'Entity analytics'
  }),
  linkIds: [_constants2.SecurityPageName.entityAnalyticsManagement, _constants2.SecurityPageName.entityAnalyticsEntityStoreManagement]
}, {
  label: _i18n.i18n.translate('xpack.securitySolution.appLinks.category.endpoints', {
    defaultMessage: 'Endpoints'
  }),
  linkIds: [_constants2.SecurityPageName.endpoints, _constants2.SecurityPageName.policies, _constants2.SecurityPageName.trustedApps, _constants2.SecurityPageName.trustedDevices, _constants2.SecurityPageName.eventFilters, _constants2.SecurityPageName.hostIsolationExceptions, _constants2.SecurityPageName.blocklist, _constants2.SecurityPageName.endpointExceptions, _constants2.SecurityPageName.responseActionsHistory, _constants2.SecurityPageName.scriptsLibrary]
}, {
  label: _i18n.i18n.translate('xpack.securitySolution.appLinks.category.cloudSecurity', {
    defaultMessage: 'Cloud Security'
  }),
  linkIds: [_constants2.SecurityPageName.cloudDefendPolicies]
}, {
  label: _i18n.i18n.translate('xpack.securitySolution.appLinks.category.investigations', {
    defaultMessage: 'Investigations'
  }),
  linkIds: [_constants2.SecurityPageName.notes]
}];
const links = exports.links = {
  id: _constants2.SecurityPageName.administration,
  title: _translations.MANAGE,
  path: _constants2.MANAGE_PATH,
  skipUrlState: true,
  hideTimeline: true,
  globalNavPosition: 12,
  capabilities: [_constants.SECURITY_UI_SHOW_PRIVILEGE],
  globalSearchKeywords: [_i18n.i18n.translate('xpack.securitySolution.appLinks.manage', {
    defaultMessage: 'Manage'
  })],
  categories,
  links: [{
    id: _constants2.SecurityPageName.endpoints,
    description: _i18n.i18n.translate('xpack.securitySolution.appLinks.endpointsDescription', {
      defaultMessage: 'Hosts running Elastic Defend.'
    }),
    landingIcon: _endpoints.IconEndpoints,
    title: _translations.ENDPOINTS,
    path: _constants2.ENDPOINTS_PATH,
    skipUrlState: true,
    hideTimeline: true
  }, {
    id: _constants2.SecurityPageName.policies,
    title: _translations.POLICIES,
    description: _i18n.i18n.translate('xpack.securitySolution.appLinks.policiesDescription', {
      defaultMessage: 'Use policies to customize endpoint and cloud workload protections and other configurations.'
    }),
    landingIcon: _policies.IconPolicies,
    path: _constants2.POLICIES_PATH,
    skipUrlState: true,
    hideTimeline: true
  }, {
    id: _constants2.SecurityPageName.trustedApps,
    title: _translations.TRUSTED_APPLICATIONS,
    description: _i18n.i18n.translate('xpack.securitySolution.appLinks.trustedApplicationsDescription', {
      defaultMessage: 'Improve performance or alleviate conflicts with other applications running on your hosts.'
    }),
    landingIcon: _trusted_applications.IconTrustedApplications,
    path: _constants2.TRUSTED_APPS_PATH,
    skipUrlState: true,
    hideTimeline: true
  }, {
    id: _constants2.SecurityPageName.trustedDevices,
    title: _translations.TRUSTED_DEVICES,
    description: _i18n.i18n.translate('xpack.securitySolution.appLinks.trustedDevicesDescription', {
      defaultMessage: 'Specify which external devices can connect to your endpoints even when Device Control is enabled.'
    }),
    landingIcon: _trusted_devices.IconTrustedDevices,
    path: _constants2.TRUSTED_DEVICES_PATH,
    skipUrlState: true,
    hideTimeline: true,
    experimentalKey: 'trustedDevices',
    capabilities: [`${_constants2.SECURITY_FEATURE_ID}.readTrustedDevices`],
    licenseType: 'enterprise'
  }, {
    id: _constants2.SecurityPageName.eventFilters,
    title: _translations.EVENT_FILTERS,
    description: _i18n.i18n.translate('xpack.securitySolution.appLinks.eventFiltersDescription', {
      defaultMessage: 'Exclude high volume or unwanted events being written into Elasticsearch.'
    }),
    landingIcon: _event_filters.IconEventFilters,
    path: _constants2.EVENT_FILTERS_PATH,
    skipUrlState: true,
    hideTimeline: true
  }, {
    id: _constants2.SecurityPageName.hostIsolationExceptions,
    title: _translations.HOST_ISOLATION_EXCEPTIONS,
    description: _i18n.i18n.translate('xpack.securitySolution.appLinks.hostIsolationDescription', {
      defaultMessage: 'Allow isolated hosts to communicate with specific IPs.'
    }),
    landingIcon: _host_isolation_exceptions.IconHostIsolationExceptions,
    path: _constants2.HOST_ISOLATION_EXCEPTIONS_PATH,
    skipUrlState: true,
    hideTimeline: true
  }, {
    id: _constants2.SecurityPageName.blocklist,
    title: _translations.BLOCKLIST,
    description: _i18n.i18n.translate('xpack.securitySolution.appLinks.blocklistDescription', {
      defaultMessage: 'Exclude unwanted applications from running on your hosts.'
    }),
    landingIcon: _blocklist.IconBlocklist,
    path: _constants2.BLOCKLIST_PATH,
    skipUrlState: true,
    hideTimeline: true
  }, {
    id: _constants2.SecurityPageName.endpointExceptions,
    title: _translations.ENDPOINT_EXCEPTIONS,
    description: _i18n.i18n.translate('xpack.securitySolution.appLinks.endpointExceptionsDescription', {
      defaultMessage: 'Add exceptions to your hosts.'
    }),
    landingIcon: _endpoint_exceptions.IconEndpointExceptions,
    path: _constants2.ENDPOINT_EXCEPTIONS_PATH,
    skipUrlState: true,
    hideTimeline: true,
    experimentalKey: 'endpointExceptionsMovedUnderManagement'
  }, {
    id: _constants2.SecurityPageName.entityAnalyticsManagement,
    title: _translations.ENTITY_ANALYTICS_RISK_SCORE,
    description: _i18n.i18n.translate('xpack.securitySolution.appLinks.entityRiskScoringDescription', {
      defaultMessage: "Monitor entities' risk scores, and track anomalies."
    }),
    landingIcon: _entity_analytics.IconEntityAnalytics,
    path: _constants2.ENTITY_ANALYTICS_MANAGEMENT_PATH,
    skipUrlState: true,
    hideTimeline: true,
    capabilities: [`${_constants2.SECURITY_FEATURE_ID}.entity-analytics`],
    licenseType: 'platinum'
  }, {
    id: _constants2.SecurityPageName.entityAnalyticsEntityStoreManagement,
    title: _translations.ENTITY_STORE,
    description: _i18n.i18n.translate('xpack.securitySolution.appLinks.entityStoreDescription', {
      defaultMessage: 'Store data for entities observed in events.'
    }),
    landingIcon: _asset_criticality.IconAssetCriticality,
    path: _constants2.ENTITY_ANALYTICS_ENTITY_STORE_MANAGEMENT_PATH,
    skipUrlState: true,
    hideTimeline: true,
    capabilities: [`${_constants2.SECURITY_FEATURE_ID}.entity-analytics`]
  }, {
    id: _constants2.SecurityPageName.responseActionsHistory,
    title: _translations.RESPONSE_ACTIONS_HISTORY,
    description: _i18n.i18n.translate('xpack.securitySolution.appLinks.actionHistoryDescription', {
      defaultMessage: 'View the history of response actions performed on hosts.'
    }),
    landingIcon: _response_action_history.IconResponseActionHistory,
    path: _constants2.RESPONSE_ACTIONS_HISTORY_PATH,
    skipUrlState: true,
    hideTimeline: true
  }, {
    id: _constants2.SecurityPageName.scriptsLibrary,
    title: _translations.SCRIPTS_LIBRARY,
    description: _i18n.i18n.translate('xpack.securitySolution.appLinks.scriptsLibraryDescription', {
      defaultMessage: 'View and manage your scripts library.'
    }),
    // TODO: Replace with a custom icon same as other links when available
    landingIcon: 'broom',
    path: _constants2.SCRIPTS_LIBRARY_PATH,
    skipUrlState: true,
    hideTimeline: true,
    experimentalKey: 'responseActionsScriptLibraryManagement',
    licenseType: 'enterprise'
  }, _links.links]
};
const excludeLinks = linkIds => {
  var _links$links;
  return {
    ...links,
    links: (_links$links = links.links) === null || _links$links === void 0 ? void 0 : _links$links.filter(link => !linkIds.includes(link.id))
  };
};
const getManagementFilteredLinks = async (core, plugins) => {
  var _plugins$fleet;
  const fleetAuthz = (_plugins$fleet = plugins.fleet) === null || _plugins$fleet === void 0 ? void 0 : _plugins$fleet.authz;
  const currentUser = await plugins.security.authc.getCurrentUser();
  const {
    canReadActionsLogManagement,
    canAccessHostIsolationExceptions,
    canReadHostIsolationExceptions,
    canReadEndpointList,
    canReadEndpointExceptions,
    canReadTrustedApplications,
    canReadTrustedDevices,
    canReadEventFilters,
    canReadBlocklist,
    canReadPolicyManagement,
    canReadScriptsLibrary
  } = fleetAuthz && currentUser ? (0, _authz.calculateEndpointAuthz)(_use_license.licenseService, fleetAuthz, currentUser.roles) : (0, _authz.getEndpointAuthzInitialState)();
  const showHostIsolationExceptions = canAccessHostIsolationExceptions ||
  // access host isolation exceptions is a paid feature, always show the link.
  // read host isolation exceptions is not a paid feature, to allow deleting exceptions after a downgrade scenario.
  // however, in this situation we allow to access only when there is data, otherwise the link won't be accessible.
  canReadHostIsolationExceptions && (await (0, _check_artifact_has_data.checkArtifactHasData)(_host_isolation_exceptions_api_client.HostIsolationExceptionsApiClient.getInstance(core.http)));
  const linksToExclude = [];
  if (!canReadEndpointList) {
    linksToExclude.push(_constants2.SecurityPageName.endpoints);
  }
  if (!canReadPolicyManagement) {
    linksToExclude.push(_constants2.SecurityPageName.policies);
    linksToExclude.push(_constants2.SecurityPageName.cloudDefendPolicies);
  }
  if (!canReadEndpointExceptions) {
    linksToExclude.push(_constants2.SecurityPageName.endpointExceptions);
  }
  if (!canReadActionsLogManagement) {
    linksToExclude.push(_constants2.SecurityPageName.responseActionsHistory);
  }
  if (!showHostIsolationExceptions) {
    linksToExclude.push(_constants2.SecurityPageName.hostIsolationExceptions);
  }
  if (!canReadTrustedApplications) {
    linksToExclude.push(_constants2.SecurityPageName.trustedApps);
  }
  if (!canReadTrustedDevices) {
    linksToExclude.push(_constants2.SecurityPageName.trustedDevices);
  }
  if (!canReadEventFilters) {
    linksToExclude.push(_constants2.SecurityPageName.eventFilters);
  }
  if (!canReadBlocklist) {
    linksToExclude.push(_constants2.SecurityPageName.blocklist);
  }
  if (!canReadScriptsLibrary) {
    linksToExclude.push(_constants2.SecurityPageName.scriptsLibrary);
  }
  return excludeLinks(linksToExclude);
};
exports.getManagementFilteredLinks = getManagementFilteredLinks;