"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RunscriptActionResult = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _user_privileges = require("../../../common/components/user_privileges");
var _response_action_file_download_link = require("../response_action_file_download_link");
var _runscript_action_output = require("./runscript_action_output");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/runscript_action_result/runscript_action_result.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Represents the result of a run script action rendered as a memoized React component.
 *
 * This component is used to display a downloadable link for a response action file.
 * Also, for specific agent types, it shows the output of the run script action.
 *
 * @param {RunscriptActionResultProps} props - The props object for the component.
 * @param {Object} props.action - The action object containing information about the run script action.
 * @param {string} props.agentId - The identifier of the agent associated with the action.
 * @param {string} [props.textSize='s'] - The size of text to be displayed. Defaults to 's' (small).
 * @param {string} [props['data-test-subj']] - An optional data-test subject attribute for testing purposes.
 *
 * @returns {React.Element} A React component that renders a text block with a file download link.
 */
const RunscriptActionResult = exports.RunscriptActionResult = /*#__PURE__*/(0, _react.memo)(({
  action,
  'data-test-subj': dataTestSubj,
  textSize = 's'
}) => {
  const {
    canWriteExecuteOperations
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const agentId = action.agents[0];
  const showFile = (0, _react.useMemo)(() => action.agentType !== 'crowdstrike', [action.agentType]);
  const shouldShowOutput = (0, _react.useMemo)(() => action.agentType === 'microsoft_defender_endpoint', [action.agentType]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showFile && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_response_action_file_download_link.ResponseActionFileDownloadLink, {
    action: action,
    canAccessFileDownloadLink: (action.agentType === 'sentinel_one' || action.agentType === 'microsoft_defender_endpoint') && canWriteExecuteOperations,
    "data-test-subj": `${dataTestSubj}-download`,
    agentId: agentId,
    textSize: textSize,
    showPasscode: action.agentType === 'sentinel_one',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 13
    }
  })), shouldShowOutput && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_runscript_action_output.RunscriptOutput, {
    action: action,
    agentId: agentId,
    "data-test-subj": `${dataTestSubj}-output`,
    textSize: textSize,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 13
    }
  })));
});
RunscriptActionResult.displayName = 'RunscriptActionResult';