"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionsLogExpandedTray = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/kibana-react-plugin/common");
var _lodash = require("lodash");
var _action_response_outputs = require("./action_response_outputs");
var _translations = require("../../../../common/translations");
var _constants = require("../../../../../common/endpoint/service/response_actions/constants");
var _translations2 = require("../translations");
var _use_test_id_generator = require("../../../hooks/use_test_id_generator");
var _empty_value = require("../../../../common/components/empty_value");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/endpoint_response_actions_list/components/action_log_expanded_tray.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const emptyValue = (0, _empty_value.getEmptyValue)();
const customDescriptionListCss = (0, _common.css)`
  &.euiDescriptionList {
    > .euiDescriptionList__title {
      color: ${props => props.theme.eui.euiColorDarkShade};
      font-size: ${props => props.theme.eui.euiFontSizeXS};
    }

    > .euiDescriptionList__title,
    > .euiDescriptionList__description {
      font-weight: ${props => props.theme.eui.euiFontWeightRegular};
    }
  }
`;
const topSpacingCss = (0, _common.css)`
  ${props => `${props.theme.eui.euiSize} 0`}
`;
const dashedBorderCss = (0, _common.css)`
  ${props => `1px dashed ${props.theme.eui.euiColorDisabled}`};
`;
const StyledDescriptionListOutput = (0, _common.euiStyled)(_eui.EuiDescriptionList).attrs({
  compressed: true
})`
  ${customDescriptionListCss}
  dd {
    margin: ${topSpacingCss};
    padding: ${topSpacingCss};
    border-top: ${dashedBorderCss};
    border-bottom: ${dashedBorderCss};
  }
`;
const StyledDescriptionList = (0, _common.euiStyled)(_eui.EuiDescriptionList).attrs({
  compressed: true,
  type: 'column'
})`
  ${customDescriptionListCss}
`;
const StyledEuiCodeBlock = (0, _common.euiStyled)(_eui.EuiCodeBlock).attrs({
  transparentBackground: true,
  paddingSize: 'none'
})`
  code {
    color: ${props => props.theme.eui.euiColorDarkShade} !important;
  }
`;
const StyledEuiFlexGroup = (0, _common.euiStyled)(_eui.EuiFlexGroup).attrs({
  direction: 'column',
  className: 'eui-yScrollWithShadows',
  gutterSize: 's'
})`
  max-height: 40vh;
  min-height: 270px;
  overflow-y: auto;
`;
const ActionsLogExpandedTray = exports.ActionsLogExpandedTray = /*#__PURE__*/(0, _react.memo)(({
  action,
  'data-test-subj': dataTestSubj
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const {
    hosts,
    startedAt,
    completedAt,
    command: _command,
    comment,
    parameters,
    agentType
  } = action;
  const parametersList = (0, _react.useMemo)(() => parameters ? Object.entries(parameters).map(([key, value]) => {
    return `${key}: ${value}`;
  }) : undefined, [parameters]);
  const command = _constants.RESPONSE_ACTION_API_COMMAND_TO_CONSOLE_COMMAND_MAP[_command];
  const dataList = (0, _react.useMemo)(() => {
    const list = [{
      title: _translations2.OUTPUT_MESSAGES.expandSection.placedAt,
      description: `${startedAt}`
    }, {
      title: _translations2.OUTPUT_MESSAGES.expandSection.startedAt,
      description: `${startedAt}`
    }, {
      title: _translations2.OUTPUT_MESSAGES.expandSection.completedAt,
      description: `${completedAt !== null && completedAt !== void 0 ? completedAt : emptyValue}`
    }, {
      title: _translations2.OUTPUT_MESSAGES.expandSection.input,
      description: `${command}`
    }, {
      title: _translations2.OUTPUT_MESSAGES.expandSection.parameters,
      description: parametersList ? parametersList.join(', ') : emptyValue
    }, {
      title: _translations2.OUTPUT_MESSAGES.expandSection.comment,
      description: comment ? comment : emptyValue
    }, {
      title: _translations2.OUTPUT_MESSAGES.expandSection.hostname,
      description: (0, _lodash.reduce)(hosts, (acc, host, agentId) => {
        if (host.name.trim().length) {
          acc.push(host.name);
        } else {
          acc.push(agentId);
        }
        return acc;
      }, []).join(', ') || emptyValue
    }, {
      title: _translations2.OUTPUT_MESSAGES.expandSection.agentType,
      description: (0, _translations.getAgentTypeName)(agentType) || emptyValue
    }];
    return list.map(({
      title,
      description
    }) => {
      return {
        title: /*#__PURE__*/_react.default.createElement(StyledEuiCodeBlock, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 154,
            columnNumber: 16
          }
        }, title),
        description: /*#__PURE__*/_react.default.createElement(StyledEuiCodeBlock, {
          "data-test-subj": getTestId(`action-details-info-${title}`),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 156,
            columnNumber: 11
          }
        }, description)
      };
    });
  }, [agentType, command, comment, completedAt, getTestId, hosts, parametersList, startedAt]);
  const outputList = (0, _react.useMemo)(() => [{
    title: /*#__PURE__*/_react.default.createElement(StyledEuiCodeBlock, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 168,
        columnNumber: 11
      }
    }, `${_translations2.OUTPUT_MESSAGES.expandSection.output}:`),
    description:
    /*#__PURE__*/
    // codeblock for output
    _react.default.createElement(StyledEuiCodeBlock, {
      "data-test-subj": getTestId('details-tray-output'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 172,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_action_response_outputs.ActionResponseOutputs, {
      action: action,
      "data-test-subj": getTestId('output'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 173,
        columnNumber: 13
      }
    }))
  }], [action, getTestId]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(StyledEuiFlexGroup, {
    "data-test-subj": getTestId('details-tray'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(StyledDescriptionList, {
    listItems: dataList,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(StyledDescriptionListOutput, {
    listItems: outputList,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 11
    }
  }))));
});
ActionsLogExpandedTray.displayName = 'ActionsLogExpandedTray';