"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useConsoleActionSubmitter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _securitysolutionHookUtils = require("@kbn/securitysolution-hook-utils");
var _i18n = require("@kbn/i18n");
var _use_test_id_generator = require("../../../hooks/use_test_id_generator");
var _action_success = require("../components/action_success");
var _action_error = require("../components/action_error");
var _formatted_error = require("../../formatted_error");
var _use_get_action_details = require("../../../hooks/response_actions/use_get_action_details");
var _constants = require("../lib/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/endpoint_responder/hooks/use_console_action_submitter.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Command store state for response action api state.
 */

/**
 * generic hook for use with Response Action commands. It will create the action, store its ID and
 * continuously pull the Action's Details until it completes. It handles all aspects of UI display
 * for the different states of the command (pending -> success/failure)
 *
 * @param actionCreator
 * @param actionRequestBody
 * @param setStatus
 * @param status
 * @param setStore
 * @param store
 * @param ResultComponent
 * @param dataTestSubj
 * @param pendingMessage
 * @param successMessage
 */
const useConsoleActionSubmitter = ({
  actionCreator,
  actionRequestBody,
  setStatus,
  status,
  setStore,
  store,
  ResultComponent,
  dataTestSubj,
  pendingMessage,
  successMessage
}) => {
  const isMounted = (0, _securitysolutionHookUtils.useIsMounted)();
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const isPending = status === 'pending';
  const currentActionState = (0, _react.useMemo)(() => {
    var _store$actionApiState;
    return (_store$actionApiState = store.actionApiState) !== null && _store$actionApiState !== void 0 ? _store$actionApiState : {
      request: {
        sent: false,
        error: undefined,
        actionId: undefined
      },
      actionDetails: undefined,
      actionDetailsError: undefined
    };
  }, [store.actionApiState]);
  const {
    actionDetails,
    actionDetailsError
  } = currentActionState;
  const {
    actionId,
    sent: actionRequestSent,
    error: actionRequestError
  } = currentActionState.request;
  const {
    data: apiActionDetailsResponse,
    error: apiActionDetailsError
  } = (0, _use_get_action_details.useGetActionDetails)(actionId !== null && actionId !== void 0 ? actionId : '-', {
    enabled: Boolean(actionId) && isPending,
    refetchInterval: isPending ? _constants.ACTION_DETAILS_REFRESH_INTERVAL : false
  });

  // Create the action request if not yet done
  (0, _react.useEffect)(() => {
    if (!actionRequestSent && actionRequestBody && isMounted()) {
      const updatedRequestState = {
        ...currentActionState.request,
        sent: true
      };

      // The object defined above (`updatedRequestState`) is saved to the command state right away.
      // the creation of the Action request (below) will mutate this object to store the Action ID
      // once the API response is received. We do this to ensure that the action is not created more
      // than once if the user happens to close the console prior to the response being returned.
      // Once a response is received, we check if the component is mounted, and if so, then we send
      // another update to the command store which will cause it to re-render and start checking for
      // action completion.
      actionCreator.mutateAsync(actionRequestBody).then(response => {
        updatedRequestState.actionId = response.data.id;
      }).catch(err => {
        updatedRequestState.error = err;
      }).finally(() => {
        // If the component is mounted, then set the store with the updated data (causes a rerender)
        if (isMounted()) {
          setStore(prevState => {
            var _prevState$actionApiS;
            return {
              ...prevState,
              actionApiState: {
                ...((_prevState$actionApiS = prevState.actionApiState) !== null && _prevState$actionApiS !== void 0 ? _prevState$actionApiS : currentActionState),
                request: {
                  ...updatedRequestState
                }
              }
            };
          });
        }
      });
      setStore(prevState => {
        var _prevState$actionApiS2;
        return {
          ...prevState,
          actionApiState: {
            ...((_prevState$actionApiS2 = prevState.actionApiState) !== null && _prevState$actionApiS2 !== void 0 ? _prevState$actionApiS2 : currentActionState),
            request: updatedRequestState
          }
        };
      });
    }
  }, [actionCreator, actionRequestBody, actionRequestSent, currentActionState, isMounted, setStore]);

  // If an error was returned while attempting to create the action request,
  // then set command status to error
  (0, _react.useEffect)(() => {
    if (actionRequestError && isPending) {
      setStatus('error');
    }
  }, [actionRequestError, isPending, setStatus]);

  // If an error was return by the Action Details API, then store it and set the status to error
  (0, _react.useEffect)(() => {
    if (apiActionDetailsError && isPending) {
      setStatus('error');
      setStore(prevState => {
        var _prevState$actionApiS3;
        return {
          ...prevState,
          actionApiState: {
            ...((_prevState$actionApiS3 = prevState.actionApiState) !== null && _prevState$actionApiS3 !== void 0 ? _prevState$actionApiS3 : currentActionState),
            actionDetails: undefined,
            actionDetailsError: apiActionDetailsError
          }
        };
      });
    }
  }, [apiActionDetailsError, currentActionState, isPending, setStatus, setStore]);

  // If the action details indicates complete, then update the action's console state and set the status to success
  (0, _react.useEffect)(() => {
    if (apiActionDetailsResponse !== null && apiActionDetailsResponse !== void 0 && apiActionDetailsResponse.data.isCompleted && isPending) {
      setStatus(apiActionDetailsResponse !== null && apiActionDetailsResponse !== void 0 && apiActionDetailsResponse.data.wasSuccessful ? 'success' : 'error');
      setStore(prevState => {
        var _prevState$actionApiS4;
        return {
          ...prevState,
          actionApiState: {
            ...((_prevState$actionApiS4 = prevState.actionApiState) !== null && _prevState$actionApiS4 !== void 0 ? _prevState$actionApiS4 : currentActionState),
            actionDetails: apiActionDetailsResponse.data
          }
          // Unclear why I needed to cast this here. For some reason the `ActionDetails['outputs']` is
          // reporting a type error for the `content` property, although the types seem to line up.
        };
      });
    }
  }, [apiActionDetailsResponse, currentActionState, isPending, setStatus, setStore]);

  // Calculate the action's UI result based on the different API responses
  const result = (0, _react.useMemo)(() => {
    if (isPending) {
      return /*#__PURE__*/_react.default.createElement(ResultComponent, {
        showAs: "pending",
        "data-test-subj": getTestId('pending'),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 268,
          columnNumber: 9
        }
      }, pendingMessage);
    }
    const apiError = actionRequestError || actionDetailsError;
    if (apiError) {
      return /*#__PURE__*/_react.default.createElement(ResultComponent, {
        showAs: "failure",
        "data-test-subj": getTestId('apiFailure'),
        title: actionRequestError ? _i18n.i18n.translate('xpack.securitySolution.useConsoleActionSubmitter.actionRequestFailure', {
          defaultMessage: 'Failed to create action request.'
        }) : undefined,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 278,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpointResponseActions.actionSubmitter.apiErrorDetails",
        defaultMessage: "The following error was encountered:",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 290,
          columnNumber: 11
        }
      }), /*#__PURE__*/_react.default.createElement(_formatted_error.FormattedError, {
        error: apiError,
        "data-test-subj": getTestId('apiErrorDetails'),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 294,
          columnNumber: 11
        }
      }));
    }
    if (actionDetails) {
      // Response action failures
      if (actionDetails.errors) {
        return /*#__PURE__*/_react.default.createElement(_action_error.ActionError, {
          ResultComponent: ResultComponent,
          action: actionDetails,
          dataTestSubj: getTestId('actionFailure'),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 303,
            columnNumber: 11
          }
        });
      }
      return /*#__PURE__*/_react.default.createElement(_action_success.ActionSuccess, {
        ResultComponent: ResultComponent,
        action: actionDetails,
        "data-test-subj": getTestId('success'),
        title: successMessage,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 312,
          columnNumber: 9
        }
      });
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }, [isPending, actionRequestError, actionDetailsError, actionDetails, ResultComponent, getTestId, pendingMessage, successMessage]);
  return {
    result,
    actionDetails: currentActionState.actionDetails
  };
};
exports.useConsoleActionSubmitter = useConsoleActionSubmitter;