"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionLogButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _response_actions_log = require("../../endpoint_response_actions_list/response_actions_log");
var _translations = require("../../endpoint_response_actions_list/translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/endpoint_responder/components/action_log_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ActionLogButton = exports.ActionLogButton = /*#__PURE__*/(0, _react.memo)(props => {
  const [showActionLogFlyout, setShowActionLogFlyout] = (0, _react.useState)(false);
  const toggleActionLog = (0, _react.useCallback)(() => {
    setShowActionLogFlyout(prevState => {
      return !prevState;
    });
  }, []);
  const responderActionLogFlyoutTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'responderActionLogFlyoutTitle'
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: toggleActionLog,
    disabled: showActionLogFlyout,
    iconType: "list",
    "data-test-subj": "responderShowActionLogButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.responseActionsHistoryButton.label",
    defaultMessage: "Response actions history",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 9
    }
  })), showActionLogFlyout && /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: toggleActionLog,
    size: "m",
    paddingSize: "l",
    "aria-labelledby": responderActionLogFlyoutTitleId,
    "data-test-subj": "responderActionLogFlyout",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h1", {
    id: responderActionLogFlyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 15
    }
  }, _translations.UX_MESSAGES.flyoutTitle(props.meta.hostName)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_response_actions_log.ResponseActionsLog, {
    agentIds: props.meta.agentId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 13
    }
  }))));
});
ActionLogButton.displayName = 'ActionLogButton';