"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExecuteActionHostResponseOutput = exports.EXECUTE_OUTPUT_FILE_TRUNCATED_MESSAGE = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/kibana-react-plugin/common");
var _use_test_id_generator = require("../../hooks/use_test_id_generator");
var _empty_value = require("../../../common/components/empty_value");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/endpoint_execute_action/execute_action_host_response_output.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const emptyValue = (0, _empty_value.getEmptyValue)();
const ACCORDION_BUTTON_TEXT = Object.freeze({
  context: _i18n.i18n.translate('xpack.securitySolution.responseActionExecuteAccordion.executionContext', {
    defaultMessage: 'Execution context'
  }),
  output: {
    regular: _i18n.i18n.translate('xpack.securitySolution.responseActionExecuteAccordion.outputButtonTextRegular', {
      defaultMessage: 'Execution output'
    }),
    truncated: _i18n.i18n.translate('xpack.securitySolution.responseActionExecuteAccordion.outputButtonTextTruncated', {
      defaultMessage: 'Execution output (truncated)'
    })
  },
  error: {
    regular: _i18n.i18n.translate('xpack.securitySolution.responseActionExecuteAccordion.errorButtonTextRegular', {
      defaultMessage: 'Execution error'
    }),
    truncated: _i18n.i18n.translate('xpack.securitySolution.responseActionExecuteAccordion.errorButtonTextTruncated', {
      defaultMessage: 'Execution error (truncated)'
    })
  }
});
const SHELL_INFO = Object.freeze({
  shell: _i18n.i18n.translate('xpack.securitySolution.responseActionExecuteAccordion.shellInformation', {
    defaultMessage: 'Shell'
  }),
  returnCode: _i18n.i18n.translate('xpack.securitySolution.responseActionExecuteAccordion.shellReturnCode', {
    defaultMessage: 'Return code'
  }),
  currentDir: _i18n.i18n.translate('xpack.securitySolution.responseActionExecuteAccordion.currentWorkingDirectory', {
    defaultMessage: 'Executed from'
  })
});
const EXECUTE_OUTPUT_FILE_TRUNCATED_MESSAGE = exports.EXECUTE_OUTPUT_FILE_TRUNCATED_MESSAGE = _i18n.i18n.translate('xpack.securitySolution.responseActionFileDownloadLink.fileTruncated', {
  defaultMessage: 'Output data in the provided zip file is truncated due to file size limitations.'
});
const StyledEuiText = (0, _common.euiStyled)(_eui.EuiText)`
  white-space: pre-wrap;
  line-break: anywhere;
`;
const ShellInfoContent = /*#__PURE__*/(0, _react.memo)(({
  content,
  textSize,
  title
}) => /*#__PURE__*/_react.default.createElement(StyledEuiText, {
  size: textSize,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 103,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement("strong", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 104,
    columnNumber: 5
  }
}, title, ': '), content));
ShellInfoContent.displayName = 'ShellInfoContent';
const ExecutionActionOutputAccordion = /*#__PURE__*/(0, _react.memo)(({
  content = emptyValue,
  initialIsOpen = false,
  isTruncated = false,
  isFileTruncated = false,
  textSize,
  type,
  'data-test-subj': dataTestSubj
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const id = (0, _eui.useGeneratedHtmlId)({
    prefix: 'executeActionOutputAccordions',
    suffix: type
  });
  const accordionButtonContent = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: textSize,
    "data-test-subj": getTestId('title'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 9
    }
  }, type !== 'context' ? isTruncated ? ACCORDION_BUTTON_TEXT[type].truncated : ACCORDION_BUTTON_TEXT[type].regular : ACCORDION_BUTTON_TEXT[type]), [getTestId, isTruncated, textSize, type]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: id,
    initialIsOpen: initialIsOpen,
    buttonContent: accordionButtonContent,
    paddingSize: "s",
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(StyledEuiText, {
    size: textSize,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 9
    }
  }, isFileTruncated && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "warning",
    "data-test-subj": getTestId('fileTruncatedMsg'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 15
    }
  }, EXECUTE_OUTPUT_FILE_TRUNCATED_MESSAGE), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 15
    }
  })), typeof content === 'string' ? /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 42
    }
  }, content) : content));
});
ExecutionActionOutputAccordion.displayName = 'ExecutionActionOutputAccordion';
// Note: also used for RunScript command
const ExecuteActionHostResponseOutput = exports.ExecuteActionHostResponseOutput = /*#__PURE__*/(0, _react.memo)(({
  outputContent,
  'data-test-subj': dataTestSubj,
  textSize = 'xs'
}) => {
  const contextContent = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    "data-test-subj": `${dataTestSubj}-shell`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(ShellInfoContent, {
    title: SHELL_INFO.shell,
    content: outputContent.shell,
    textSize: textSize,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(ShellInfoContent, {
    title: SHELL_INFO.returnCode,
    content: outputContent.shell_code,
    textSize: textSize,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": `${dataTestSubj}-cwd`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(ShellInfoContent, {
    title: SHELL_INFO.currentDir,
    content: outputContent.cwd,
    textSize: textSize,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 13
    }
  }))), [dataTestSubj, outputContent.cwd, outputContent.shell, outputContent.shell_code, textSize]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(ExecutionActionOutputAccordion, {
    content: contextContent,
    "data-test-subj": `${dataTestSubj}-context`,
    textSize: textSize,
    type: "context",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 9
    }
  }, outputContent.stderr.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(ExecutionActionOutputAccordion, {
    content: outputContent.stderr.length ? outputContent.stderr : undefined,
    "data-test-subj": `${dataTestSubj}-error`,
    isTruncated: outputContent.stderr_truncated,
    isFileTruncated: outputContent.output_file_stderr_truncated,
    textSize: textSize,
    initialIsOpen: true,
    type: "error",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 244,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(ExecutionActionOutputAccordion, {
    content: outputContent.stdout.length ? outputContent.stdout : undefined,
    "data-test-subj": `${dataTestSubj}-output`,
    isTruncated: outputContent.stdout_truncated,
    isFileTruncated: outputContent.output_file_stdout_truncated,
    initialIsOpen: true,
    textSize: textSize,
    type: "output",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 245,
      columnNumber: 11
    }
  })));
});
ExecuteActionHostResponseOutput.displayName = 'ExecuteActionHostResponseOutput';