"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleSidePanel = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const handleSidePanel = (state, action) => {
  switch (action.type) {
    case 'showSidePanel':
      if (state.sidePanel.show !== action.payload.show) {
        return {
          ...state,
          sidePanel: {
            ...state.sidePanel,
            show: action.payload.show
          }
        };
      }
      break;
  }
  return state;
};
exports.handleSidePanel = handleSidePanel;