"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CommandInputClearHistory = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _use_test_id_generator = require("../../../../../hooks/use_test_id_generator");
var _use_data_test_subj = require("../../../hooks/state_selectors/use_data_test_subj");
var _use_console_state_dispatch = require("../../../hooks/state_selectors/use_console_state_dispatch");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/console/components/command_input/components/command_input_clear_history.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CommandInputClearHistory = exports.CommandInputClearHistory = /*#__PURE__*/(0, _react.memo)(() => {
  const [showConfirmModal, setShowConfirmModal] = (0, _react.useState)(false);
  const dispatch = (0, _use_console_state_dispatch.useConsoleStateDispatch)();
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)((0, _use_data_test_subj.useDataTestSubj)());
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const handleClearInputHistory = (0, _react.useCallback)(() => {
    setShowConfirmModal(true);
  }, []);
  const handleConfirmModalCancel = (0, _react.useCallback)(() => {
    setShowConfirmModal(false);
  }, []);
  const handleConfirmModalConfirm = (0, _react.useCallback)(() => {
    dispatch({
      type: 'clearInputHistoryState'
    });
    setShowConfirmModal(false);
  }, [dispatch]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showConfirmModal && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    titleProps: {
      id: modalTitleId
    },
    title: _i18n.i18n.translate('xpack.securitySolution.commandInputClearHistory.confirmTitle', {
      defaultMessage: 'Clear input history'
    }),
    cancelButtonText: _i18n.i18n.translate('xpack.securitySolution.commandInputClearHistory.confirmCancelButton', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.securitySolution.commandInputClearHistory.confirmSubmitButton', {
      defaultMessage: 'Clear'
    }),
    buttonColor: "danger",
    onCancel: handleConfirmModalCancel,
    onConfirm: handleConfirmModalConfirm,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.commandInputClearHistory.confirmMessage",
    defaultMessage: "This action cannot be undone. Are you sure you wish to continue?",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    justifyContent: "flexEnd",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    tabIndex: -1,
    onClick: handleClearInputHistory,
    disabled: showConfirmModal,
    "data-test-subj": getTestId('clearInputHistoryButton'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.commandInputClearHistory.clearHistoryButtonLabel",
    defaultMessage: "Clear input history",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 13
    }
  })))));
});
CommandInputClearHistory.displayName = 'CommandInputClearHistory';