"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CommandInput = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _classnames = _interopRequireDefault(require("classnames"));
var _securitysolutionHookUtils = require("@kbn/securitysolution-hook-utils");
var _input_display = require("./components/input_display");
var _use_with_input_show_popover = require("../../hooks/state_selectors/use_with_input_show_popover");
var _entered_input = require("./lib/entered_input");
var _input_capture = require("./components/input_capture");
var _use_with_input_visible_state = require("../../hooks/state_selectors/use_with_input_visible_state");
var _use_input_hints = require("./hooks/use_input_hints");
var _input_placeholder = require("./components/input_placeholder");
var _use_with_input_text_entered = require("../../hooks/state_selectors/use_with_input_text_entered");
var _input_area_popover = require("./components/input_area_popover");
var _use_console_state_dispatch = require("../../hooks/state_selectors/use_console_state_dispatch");
var _use_test_id_generator = require("../../../../hooks/use_test_id_generator");
var _use_data_test_subj = require("../../hooks/state_selectors/use_data_test_subj");
var _use_with_command_list = require("../../hooks/state_selectors/use_with_command_list");
var _utils = require("./lib/utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/console/components/command_input/command_input.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CommandInputContainer = _styledComponents.default.div`
  background-color: ${({
  theme: {
    eui
  }
}) => eui.euiFormBackgroundColor};
  border-radius: ${({
  theme: {
    eui
  }
}) => eui.euiBorderRadius};
  padding: ${({
  theme: {
    eui
  }
}) => eui.euiSizeS};
  outline: ${({
  theme: {
    eui
  }
}) => eui.euiBorderThin};

  border-bottom: ${({
  theme: {
    eui
  }
}) => eui.euiBorderThick};
  border-bottom-color: transparent;

  &:focus-within {
    border-bottom-color: ${({
  theme: {
    eui
  }
}) => eui.euiColorPrimary};
  }

  &.error {
    border-bottom-color: ${({
  theme: {
    eui
  }
}) => eui.euiColorDanger};
  }

  .textEntered {
    white-space: break-spaces;
  }

  .prompt {
    padding-right: 1ch;
  }

  &.withPopover {
    border-top-left-radius: 0;
    border-top-right-radius: 0;
  }

  &.hasFocus {
    // Cursor is defined in '<InputDisplay>' component
    .cursor {
      background-color: ${({
  theme: {
    eui
  }
}) => eui.euiTextColor};
      animation: cursor-blink-animation 1s steps(5, start) infinite;
      -webkit-animation: cursor-blink-animation 1s steps(5, start) infinite;

      @keyframes cursor-blink-animation {
        to {
          visibility: hidden;
        }
      }
      @-webkit-keyframes cursor-blink-animation {
        to {
          visibility: hidden;
        }
      }
    }
  }
`;
const CommandInput = exports.CommandInput = /*#__PURE__*/(0, _react.memo)(({
  prompt = '',
  focusRef,
  ...commonProps
}) => {
  (0, _use_input_hints.useInputHints)();
  const isMounted = (0, _securitysolutionHookUtils.useIsMounted)();
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)((0, _use_data_test_subj.useDataTestSubj)());
  const dispatch = (0, _use_console_state_dispatch.useConsoleStateDispatch)();
  const commands = (0, _use_with_command_list.useWithCommandList)();
  const {
    rightOfCursorText,
    leftOfCursorText,
    fullTextEntered,
    enteredCommand,
    parsedInput
  } = (0, _use_with_input_text_entered.useWithInputTextEntered)();
  const visibleState = (0, _use_with_input_visible_state.useWithInputVisibleState)();
  const isPopoverOpen = !!(0, _use_with_input_show_popover.useWithInputShowPopover)();
  const [isKeyInputBeingCaptured, setIsKeyInputBeingCaptured] = (0, _react.useState)(false);
  const [commandToExecute, setCommandToExecute] = (0, _react.useState)(undefined);
  const [popoverWidth, setPopoverWidth] = (0, _react.useState)('94vw');
  const _focusRef = (0, _react.useRef)(null);
  const keyCaptureFocusRef = focusRef || _focusRef;
  const inputContainerClassname = (0, _react.useMemo)(() => {
    return (0, _classnames.default)({
      cmdInput: true,
      hasFocus: isKeyInputBeingCaptured,
      error: visibleState === 'error',
      withPopover: isPopoverOpen
    });
  }, [isKeyInputBeingCaptured, isPopoverOpen, visibleState]);
  const disableArrowButton = (0, _react.useMemo)(() => fullTextEntered.trim().length === 0, [fullTextEntered]);
  const userInput = (0, _react.useMemo)(() => {
    return new _entered_input.EnteredInput(leftOfCursorText, rightOfCursorText, parsedInput, enteredCommand);
  }, [enteredCommand, leftOfCursorText, parsedInput, rightOfCursorText]);
  const handleOnResize = (0, _react.useCallback)(({
    width
  }) => {
    if (width > 0) {
      setPopoverWidth(`${width}px`);
    }
  }, []);
  const handleSubmitButton = (0, _react.useCallback)(() => {
    setCommandToExecute({
      input: userInput.getFullText(true),
      enteredCommand,
      parsedInput
    });
  }, [enteredCommand, parsedInput, userInput]);
  const handleOnChangeFocus = (0, _react.useCallback)(hasFocus => {
    setIsKeyInputBeingCaptured(hasFocus);
  }, []);
  const handleTypingAreaClick = (0, _react.useCallback)(ev => {
    // We don't want to trigger input area focus if the click was done from a component that
    // resides OUTSIDE of the typing areas. This can be the case with commands that have an argument
    // value component (aka: argument selector), where events done from inside those components
    // all bubble up through the input area - and this includes events from components inside
    // Portals - like popups - where the HTML element is NOT inside this typing area.
    const {
      currentTarget,
      target
    } = ev;
    if (currentTarget !== target && target instanceof Node && !currentTarget.contains(target)) {
      if (isKeyInputBeingCaptured && keyCaptureFocusRef.current) {
        keyCaptureFocusRef.current.blur();
      }
      return;
    }
    if (keyCaptureFocusRef.current) {
      keyCaptureFocusRef.current.focus();
    }
    if (isPopoverOpen) {
      dispatch({
        type: 'updateInputPopoverState',
        payload: {
          show: undefined
        }
      });
    }
  }, [dispatch, isKeyInputBeingCaptured, isPopoverOpen, keyCaptureFocusRef]);
  const handleInputCapture = (0, _react.useCallback)(({
    value,
    selection,
    eventDetails
  }) => {
    const key = eventDetails.code;

    // UP arrow key
    if (key === 'ArrowUp') {
      dispatch({
        type: 'removeFocusFromKeyCapture'
      });
      dispatch({
        type: 'updateInputPopoverState',
        payload: {
          show: 'input-history'
        }
      });
      return;
    }

    // Handle any input value by pre-processing selector arguments (paste, history, etc.)
    let processedValue = value;
    let extractedArgState = {};
    if (value) {
      const preProcessResult = (0, _utils.detectAndPreProcessPastedCommand)(value, commands);
      if (preProcessResult.hasSelectorArguments) {
        processedValue = preProcessResult.cleanedCommand;
        extractedArgState = preProcessResult.extractedArgState;
      }
    }

    // Update the store with the updated text that was entered
    dispatch({
      type: 'updateInputTextEnteredState',
      payload: ({
        leftOfCursorText: prevLeftOfCursor,
        rightOfCursorText: prevRightOfCursor,
        enteredCommand: prevEnteredCommand,
        parsedInput: prevParsedInput
      }) => {
        var _processedValue;
        const inputText = new _entered_input.EnteredInput(prevLeftOfCursor, prevRightOfCursor, prevParsedInput, prevEnteredCommand);
        inputText.addValue((_processedValue = processedValue) !== null && _processedValue !== void 0 ? _processedValue : '', selection);
        switch (key) {
          // BACKSPACE
          case 'Backspace':
            inputText.backspaceChar(selection);
            break;

          // DELETE
          case 'Delete':
            inputText.deleteChar(selection);
            break;

          // ENTER = Execute command and blank out the input area
          case 'Enter':
            // In order to avoid triggering another state update while this one is being processed,
            // we defer the setting of the command to execute until this state update is done
            // This essentially avoids the React warning:
            //    "Cannot update a component (`name here`) while rendering a different component (`name here`)"
            {
              const commandToExecutePayload = {
                input: inputText.getFullText(true),
                enteredCommand: prevEnteredCommand,
                parsedInput: prevParsedInput
              };
              Promise.resolve().then(() => {
                if (isMounted()) {
                  setCommandToExecute(commandToExecutePayload);
                }
              });
              inputText.clear();
            }
            break;

          // ARROW LEFT
          case 'ArrowLeft':
            inputText.moveCursorTo('left');
            break;

          // ARROW RIGHT
          case 'ArrowRight':
            inputText.moveCursorTo('right');
            break;

          // HOME
          case 'Home':
            inputText.moveCursorTo('home');
            break;

          // END
          case 'End':
            inputText.moveCursorTo('end');
            break;
        }
        return {
          leftOfCursorText: inputText.getLeftOfCursorText(),
          rightOfCursorText: inputText.getRightOfCursorText(),
          argState: {
            ...inputText.getArgState(),
            ...extractedArgState
          }
        };
      }
    });
  }, [commands, dispatch, isMounted]);

  // Execute the command if one was ENTER'd.
  (0, _react.useEffect)(() => {
    if (commandToExecute) {
      dispatch({
        type: 'executeCommand',
        payload: commandToExecute
      });
      setCommandToExecute(undefined);

      // reset input
      dispatch({
        type: 'updateInputTextEnteredState',
        payload: {
          leftOfCursorText: '',
          rightOfCursorText: ''
        }
      });
    }
  }, [commandToExecute, dispatch]);
  return /*#__PURE__*/_react.default.createElement(_input_area_popover.InputAreaPopover, {
    width: popoverWidth,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 300,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiResizeObserver, {
    onResize: handleOnResize,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 301,
      columnNumber: 7
    }
  }, resizeRef => {
    return /*#__PURE__*/_react.default.createElement(CommandInputContainer, (0, _extends2.default)({}, commonProps, {
      className: inputContainerClassname,
      onClick: handleTypingAreaClick,
      ref: resizeRef,
      "data-test-subj": getTestId('cmdInput-container'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 304,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      alignItems: "center",
      gutterSize: "none",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 311,
        columnNumber: 15
      }
    }, prompt && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      "data-test-subj": getTestId('cmdInput-prompt'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 313,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      className: "eui-displayInlineBlock prompt",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 314,
        columnNumber: 21
      }
    }, prompt)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      className: "textEntered",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 317,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_input_capture.InputCapture, {
      onCapture: handleInputCapture,
      onChangeFocus: handleOnChangeFocus,
      focusRef: focusRef,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 318,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_input_display.InputDisplay, {
      leftOfCursor: userInput.getLeftOfCursorRenderingContent(),
      rightOfCursor: userInput.getRightOfCursorRenderingContent(),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 323,
        columnNumber: 21
      }
    })), /*#__PURE__*/_react.default.createElement(_input_placeholder.InputPlaceholder, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 328,
        columnNumber: 19
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 330,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": getTestId('inputTextSubmitButton'),
      "aria-label": "submit-command",
      iconType: "playFilled",
      color: "primary",
      isDisabled: disableArrowButton,
      onClick: handleSubmitButton,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 331,
        columnNumber: 19
      }
    }))));
  }));
});
CommandInput.displayName = 'CommandInput';