"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useWithArtifactSubmitData = void 0;
var _artifacts = require("../../../hooks/artifacts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useWithArtifactSubmitData = (apiClient, mode) => {
  const artifactUpdater = (0, _artifacts.useUpdateArtifact)(apiClient);
  const artifactCreator = (0, _artifacts.useCreateArtifact)(apiClient);
  return mode === 'create' ? artifactCreator : artifactUpdater;
};
exports.useWithArtifactSubmitData = useWithArtifactSubmitData;