"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTrustedAppProviderMock = exports.getExceptionProviderMock = void 0;
var _lodash = require("lodash");
var _uuid = require("uuid");
var _exception_list_item_schema = require("@kbn/lists-plugin/common/schemas/response/exception_list_item_schema.mock");
var _trusted_app_generator = require("../../../../common/endpoint/data_generators/trusted_app_generator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCommonItemDataOverrides = () => {
  return {
    name: 'some internal app',
    description: 'this app is trusted by the company',
    created_at: new Date('2021-07-01').toISOString()
  };
};
const getTrustedAppProviderMock = () => new _trusted_app_generator.TrustedAppGenerator('seed').generate(getCommonItemDataOverrides());
exports.getTrustedAppProviderMock = getTrustedAppProviderMock;
const getExceptionProviderMock = () => {
  // Grab the properties from the generated Trusted App that should be the same across both types
  const {
    name,
    description,
    created_at,
    updated_at,
    updated_by,
    created_by,
    id
  } = getTrustedAppProviderMock();

  // cloneDeep needed because exception mock generator uses state across instances
  return (0, _lodash.cloneDeep)((0, _exception_list_item_schema.getExceptionListItemSchemaMock)({
    name,
    description,
    created_at,
    updated_at,
    updated_by,
    created_by,
    id,
    os_types: ['windows'],
    entries: [{
      field: 'process.hash.*',
      operator: 'included',
      type: 'match',
      value: '1234234659af249ddf3e40864e9fb241'
    }, {
      field: 'process.executable.caseless',
      operator: 'included',
      type: 'match',
      value: 'c:\\fol\\bin.exe'
    }],
    tags: ['policy:all'],
    comments: [{
      id: (0, _uuid.v4)(),
      comment: 'test',
      created_at: new Date().toISOString(),
      created_by: 'Justa'
    }]
  }));
};
exports.getExceptionProviderMock = getExceptionProviderMock;