"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hasAccessToCases = hasAccessToCases;
exports.hasAccessToRules = hasAccessToRules;
exports.hasAccessToSecuritySolution = hasAccessToSecuritySolution;
exports.isSecuritySolutionAccessible = isSecuritySolutionAccessible;
var _constants = require("@kbn/security-solution-features/constants");
var _constants2 = require("../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function hasAccessToSecuritySolution(capabilities) {
  var _capabilities$SECURIT, _capabilities$securit;
  return Boolean(((_capabilities$SECURIT = capabilities[_constants2.SECURITY_FEATURE_ID]) === null || _capabilities$SECURIT === void 0 ? void 0 : _capabilities$SECURIT.show) || ((_capabilities$securit = capabilities.securitySolutionAttackDiscovery) === null || _capabilities$securit === void 0 ? void 0 : _capabilities$securit['attack-discovery']) || hasAccessToRules(capabilities));
}
function hasAccessToRules(capabilities) {
  var _capabilities$securit2;
  return Boolean((_capabilities$securit2 = capabilities.securitySolutionRulesV1) === null || _capabilities$securit2 === void 0 ? void 0 : _capabilities$securit2[_constants.RULES_UI_READ]);
}
function hasAccessToCases(capabilities) {
  var _capabilities$CASES_F;
  return Boolean((_capabilities$CASES_F = capabilities[_constants2.CASES_FEATURE_ID]) === null || _capabilities$CASES_F === void 0 ? void 0 : _capabilities$CASES_F.read_cases);
}
function isSecuritySolutionAccessible(capabilities) {
  return hasAccessToSecuritySolution(capabilities) || hasAccessToCases(capabilities);
}