"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRuleDetails = void 0;
var _react = require("react");
var _use_rule_with_fallback = require("../../../detection_engine/rule_management/logic/use_rule_with_fallback");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook to retrieve rule details for rule details flyout
 */
const useRuleDetails = ({
  ruleId
}) => {
  const [rule, setRule] = (0, _react.useState)(null);
  const {
    rule: maybeRule,
    loading,
    isExistingRule
  } = (0, _use_rule_with_fallback.useRuleWithFallback)(ruleId !== null && ruleId !== void 0 ? ruleId : '');

  // persist rule until refresh is complete
  (0, _react.useEffect)(() => {
    if (maybeRule != null) {
      setRule(maybeRule);
    }
  }, [maybeRule]);
  return (0, _react.useMemo)(() => ({
    rule,
    loading,
    isExistingRule
  }), [loading, isExistingRule, rule]);
};
exports.useRuleDetails = useRuleDetails;