"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableTab = exports.FLYOUT_TABLE_TEST_ID = void 0;
var _react = _interopRequireWildcard(require("react"));
var _context = require("../context");
var _empty_prompt = require("../components/empty_prompt");
var _fields_table = require("../components/fields_table");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/ioc_details/tabs/table_tab.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FLYOUT_TABLE_TEST_ID = exports.FLYOUT_TABLE_TEST_ID = 'tiFlyoutTable';

/**
 * Table view displayed in the document details expandable flyout right section
 */
const TableTab = exports.TableTab = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    indicator
  } = (0, _context.useIOCDetailsContext)();
  const items = Object.keys(indicator.fields);
  return items.length === 0 ? /*#__PURE__*/_react.default.createElement(_empty_prompt.IndicatorEmptyPrompt, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 23,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_fields_table.IndicatorFieldsTable, {
    "data-test-subj": FLYOUT_TABLE_TEST_ID,
    fields: items,
    indicator: indicator,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 5
    }
  });
});
TableTab.displayName = 'TableTab';