"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OverviewTab = exports.INDICATORS_FLYOUT_OVERVIEW_TITLE = exports.INDICATORS_FLYOUT_OVERVIEW_TABLE = exports.INDICATORS_FLYOUT_OVERVIEW_HIGH_LEVEL_BLOCKS = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _panel_keys = require("../constants/panel_keys");
var _field_value = require("../../../threat_intelligence/modules/indicators/utils/field_value");
var _empty_prompt = require("../components/empty_prompt");
var _unwrap_value = require("../../../threat_intelligence/modules/indicators/utils/unwrap_value");
var _indicator = require("../../../../common/threat_intelligence/types/indicator");
var _block = require("../components/block");
var _highlighted_values_table = require("../components/highlighted_values_table");
var _context = require("../context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/ioc_details/tabs/overview_tab.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const INDICATORS_FLYOUT_OVERVIEW_TITLE = exports.INDICATORS_FLYOUT_OVERVIEW_TITLE = 'tiFlyoutOverviewTitle';
const INDICATORS_FLYOUT_OVERVIEW_TABLE = exports.INDICATORS_FLYOUT_OVERVIEW_TABLE = 'tiFlyoutOverviewTableRow';
const INDICATORS_FLYOUT_OVERVIEW_HIGH_LEVEL_BLOCKS = exports.INDICATORS_FLYOUT_OVERVIEW_HIGH_LEVEL_BLOCKS = 'tiFlyoutOverviewHighLevelBlocks';
const highLevelFields = [_indicator.RawIndicatorFieldId.Feed, _indicator.RawIndicatorFieldId.Type, _indicator.RawIndicatorFieldId.MarkingTLP, _indicator.RawIndicatorFieldId.Confidence];

/**
 * Overview view displayed in the document details expandable flyout right section
 */
const OverviewTab = exports.OverviewTab = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    indicator
  } = (0, _context.useIOCDetailsContext)();
  const {
    openRightPanel
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const indicatorType = (0, _unwrap_value.unwrapValue)(indicator, _indicator.RawIndicatorFieldId.Type);
  const highLevelBlocks = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": INDICATORS_FLYOUT_OVERVIEW_HIGH_LEVEL_BLOCKS,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 7
    }
  }, highLevelFields.map(field => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: field,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_block.IndicatorBlock, {
    indicator: indicator,
    field: field,
    "data-test-subj": INDICATORS_FLYOUT_OVERVIEW_HIGH_LEVEL_BLOCKS,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 13
    }
  })))), [indicator]);
  const indicatorDescription = (0, _react.useMemo)(() => {
    const unwrappedDescription = (0, _unwrap_value.unwrapValue)(indicator, _indicator.RawIndicatorFieldId.Description);
    return unwrappedDescription ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 35
      }
    }, unwrappedDescription) : null;
  }, [indicator]);
  const title = (0, _field_value.getIndicatorFieldAndValue)(indicator, _indicator.RawIndicatorFieldId.Name).value;
  const onViewAllFieldsInTable = (0, _react.useCallback)(() => openRightPanel({
    id: _panel_keys.IOCRightPanelKey,
    path: {
      tab: 'table'
    },
    params: {
      id: indicator._id
    }
  }), [indicator._id, openRightPanel]);
  if (!indicatorType) {
    return /*#__PURE__*/_react.default.createElement(_empty_prompt.IndicatorEmptyPrompt, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    "data-test-subj": INDICATORS_FLYOUT_OVERVIEW_TITLE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 9
    }
  }, title)), indicatorDescription, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 7
    }
  }), highLevelBlocks, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.threatIntelligence.indicator.flyoutOverviewTable.highlightedFields",
    defaultMessage: "Highlighted fields",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onViewAllFieldsInTable,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.threatIntelligence.indicator.flyoutOverviewTable.viewAllFieldsInTable",
    defaultMessage: "View all fields in table",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_highlighted_values_table.HighlightedValuesTable, {
    indicator: indicator,
    "data-test-subj": INDICATORS_FLYOUT_OVERVIEW_TABLE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 7
    }
  }));
});
OverviewTab.displayName = 'OverviewTab';