"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useObservedUserItems = void 0;
var _react = _interopRequireWildcard(require("react"));
var _formatted_date = require("../../../../common/components/formatted_date");
var _use_ml_capabilities = require("../../../../common/components/ml/hooks/use_ml_capabilities");
var _common = require("../../shared/common");
var i18n = _interopRequireWildcard(require("./translations"));
var _empty_value = require("../../../../common/components/empty_value");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/entity_details/user_right/hooks/use_observed_user_items.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const basicUserFields = [{
  label: i18n.USER_ID,
  getValues: userData => {
    var _userData$details$use;
    return (_userData$details$use = userData.details.user) === null || _userData$details$use === void 0 ? void 0 : _userData$details$use.id;
  },
  field: 'user.id'
}, {
  label: 'Domain',
  getValues: userData => {
    var _userData$details$use2;
    return (_userData$details$use2 = userData.details.user) === null || _userData$details$use2 === void 0 ? void 0 : _userData$details$use2.domain;
  },
  field: 'user.domain'
}, {
  label: i18n.FIRST_SEEN,
  render: userData => userData.firstSeen.date ? /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
    value: userData.firstSeen.date,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 9
    }
  }) : (0, _empty_value.getEmptyTagValue)()
}, {
  label: i18n.LAST_SEEN,
  render: userData => userData.lastSeen.date ? /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
    value: userData.lastSeen.date,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 9
    }
  }) : (0, _empty_value.getEmptyTagValue)()
}, {
  label: i18n.OPERATING_SYSTEM_TITLE,
  getValues: userData => {
    var _userData$details$hos, _userData$details$hos2;
    return (_userData$details$hos = userData.details.host) === null || _userData$details$hos === void 0 ? void 0 : (_userData$details$hos2 = _userData$details$hos.os) === null || _userData$details$hos2 === void 0 ? void 0 : _userData$details$hos2.name;
  },
  field: 'host.os.name'
}, {
  label: i18n.FAMILY,
  getValues: userData => {
    var _userData$details$hos3, _userData$details$hos4;
    return (_userData$details$hos3 = userData.details.host) === null || _userData$details$hos3 === void 0 ? void 0 : (_userData$details$hos4 = _userData$details$hos3.os) === null || _userData$details$hos4 === void 0 ? void 0 : _userData$details$hos4.family;
  },
  field: 'host.os.family'
}, {
  label: i18n.IP_ADDRESSES,
  getValues: userData => {
    var _userData$details$hos5;
    return (_userData$details$hos5 = userData.details.host) === null || _userData$details$hos5 === void 0 ? void 0 : _userData$details$hos5.ip;
  },
  field: 'host.ip'
}];
const useObservedUserItems = userData => {
  const mlCapabilities = (0, _use_ml_capabilities.useMlCapabilities)();
  const fields = (0, _react.useMemo)(() => [...basicUserFields, ...(0, _common.getAnomaliesFields)(mlCapabilities)], [mlCapabilities]);
  if (!userData.details) {
    return [];
  }
  return fields;
};
exports.useObservedUserItems = useObservedUserItems;