"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNavigateToHostDetails = void 0;
var _react = require("react");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _search_strategy = require("../../../../../common/search_strategy");
var _kibana = require("../../../../common/lib/kibana");
var _host_details_left = require("../../host_details_left");
var _telemetry = require("../../../../common/lib/telemetry");
var _constants = require("../../shared/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useNavigateToHostDetails = ({
  hostName,
  scopeId,
  isRiskScoreExist,
  hasMisconfigurationFindings,
  hasVulnerabilitiesFindings,
  hasNonClosedAlerts,
  isPreviewMode,
  contextID
}) => {
  const {
    telemetry
  } = (0, _kibana.useKibana)().services;
  const {
    openLeftPanel,
    openFlyout
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  telemetry.reportEvent(_telemetry.EntityEventTypes.RiskInputsExpandedFlyoutOpened, {
    entity: _search_strategy.EntityType.host
  });
  return (0, _react.useCallback)(path => {
    const left = {
      id: _host_details_left.HostDetailsPanelKey,
      params: {
        name: hostName,
        scopeId,
        isRiskScoreExist,
        path,
        hasMisconfigurationFindings,
        hasVulnerabilitiesFindings,
        hasNonClosedAlerts
      }
    };
    const right = {
      id: _constants.HostPanelKey,
      params: {
        contextID,
        scopeId,
        hostName
      }
    };
    if (isPreviewMode) {
      openFlyout({
        right,
        left
      });
    } else {
      openLeftPanel(left);
    }
  }, [isPreviewMode, openFlyout, openLeftPanel, hostName, scopeId, isRiskScoreExist, hasMisconfigurationFindings, hasVulnerabilitiesFindings, hasNonClosedAlerts, contextID]);
};
exports.useNavigateToHostDetails = useNavigateToHostDetails;