"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useHighlightedFieldsPrivilege = void 0;
var _i18n = require("@kbn/i18n");
var _react = require("react");
var _has_ml_admin_permissions = require("../../../../../common/machine_learning/has_ml_admin_permissions");
var _has_ml_license = require("../../../../../common/machine_learning/has_ml_license");
var _helpers = require("../../../../../common/machine_learning/helpers");
var _use_ml_capabilities = require("../../../../common/components/ml/hooks/use_ml_capabilities");
var _user_privileges = require("../../../../common/components/user_privileges");
var _privileges = require("../../../../common/utils/privileges");
var _use_prebuilt_rule_customization_upselling_message = require("../../../../detection_engine/rule_management/logic/prebuilt_rules/use_prebuilt_rule_customization_upselling_message");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns whether the edit highlighted fields button is disabled and the tooltip content
 */
const useHighlightedFieldsPrivilege = ({
  rule,
  isExistingRule
}) => {
  const canEditRules = (0, _user_privileges.useUserPrivileges)().rulesPrivileges.edit;
  const mlCapabilities = (0, _use_ml_capabilities.useMlCapabilities)();
  const hasMlPermissions = (0, _has_ml_license.hasMlLicense)(mlCapabilities) && (0, _has_ml_admin_permissions.hasMlAdminPermissions)(mlCapabilities);
  const isEditRuleDisabled = !rule || !isExistingRule || !canEditRules || (0, _helpers.isMlRule)(rule === null || rule === void 0 ? void 0 : rule.type) && !hasMlPermissions;
  const upsellingMessage = (0, _use_prebuilt_rule_customization_upselling_message.usePrebuiltRuleCustomizationUpsellingMessage)('prebuilt_rule_customization');
  const isDisabled = isEditRuleDisabled || Boolean(upsellingMessage) && (rule === null || rule === void 0 ? void 0 : rule.immutable);
  const tooltipContent = (0, _react.useMemo)(() => {
    const explanation = (0, _privileges.explainLackOfPermission)(rule, hasMlPermissions, true,
    // default true because we don't need the message for lack of action privileges
    canEditRules);
    if (isEditRuleDisabled && explanation) {
      return explanation;
    }
    if (isEditRuleDisabled && (!isExistingRule || !rule)) {
      return _i18n.i18n.translate('xpack.securitySolution.flyout.right.investigation.highlightedFields.editHighlightedFieldsDeletedRuleTooltip', {
        defaultMessage: 'Deleted rule cannot be edited.'
      });
    }
    if (upsellingMessage && rule !== null && rule !== void 0 && rule.immutable) {
      return _i18n.i18n.translate('xpack.securitySolution.flyout.right.investigation.highlightedFields.editHighlightedFieldsButtonUpsellingTooltip', {
        defaultMessage: '{upsellingMessage}',
        values: {
          upsellingMessage
        }
      });
    }
    return _i18n.i18n.translate('xpack.securitySolution.flyout.right.investigation.highlightedFields.editHighlightedFieldsButtonTooltip', {
      defaultMessage: 'Edit highlighted fields'
    });
  }, [canEditRules, hasMlPermissions, isEditRuleDisabled, isExistingRule, rule, upsellingMessage]);
  return (0, _react.useMemo)(() => ({
    isDisabled,
    tooltipContent
  }), [isDisabled, tooltipContent]);
};
exports.useHighlightedFieldsPrivilege = useHighlightedFieldsPrivilege;