"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGraphPreview = void 0;
var _fp = require("lodash/fp");
var _public = require("@kbn/kibana-react-plugin/public");
var _cloudSecurityPostureCommon = require("@kbn/cloud-security-posture-common");
var _utils = require("../utils");
var _use_basic_data_from_details_data = require("./use_basic_data_from_details_data");
var _use_has_graph_visualization_license = require("../../../../common/hooks/use_has_graph_visualization_license");
var _constants = require("../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Interface for the result of the useGraphPreview hook
 */

/**
 * Hook that returns the graph view configuration if the graph view is available for the alert
 */
const useGraphPreview = ({
  getFieldsData,
  ecsData,
  dataFormattedForFieldBrowser
}) => {
  const timestamp = (0, _utils.getField)(getFieldsData('@timestamp'));
  const originalEventId = getFieldsData('kibana.alert.original_event.id');
  const eventId = getFieldsData('event.id');
  const eventIds = originalEventId ? (0, _utils.getFieldArray)(originalEventId) : (0, _utils.getFieldArray)(eventId);

  // Get actor IDs from new ECS schema fields only
  const actorIds = [];
  _cloudSecurityPostureCommon.GRAPH_ACTOR_ENTITY_FIELDS.forEach(field => {
    const fieldValues = (0, _utils.getFieldArray)(getFieldsData(field));
    actorIds.push(...fieldValues);
  });

  // Get target IDs from new ECS schema fields only
  const targetIds = [];
  _cloudSecurityPostureCommon.GRAPH_TARGET_ENTITY_FIELDS.forEach(field => {
    const fieldValues = (0, _utils.getFieldArray)(getFieldsData(field));
    targetIds.push(...fieldValues);
  });
  const action = (0, _fp.get)(['event', 'action'], ecsData);

  // Check if user license is high enough to access graph visualization
  const hasRequiredLicense = (0, _use_has_graph_visualization_license.useHasGraphVisualizationLicense)();

  // Check if graph visualization feature is enabled in UI settings
  const [isGraphFeatureEnabled] = (0, _public.useUiSetting$)(_constants.ENABLE_GRAPH_VISUALIZATION_SETTING);

  // Check if graph has all required data fields for graph visualization
  const hasGraphRepresentation = Boolean(timestamp) && Boolean(action === null || action === void 0 ? void 0 : action.length) && eventIds.length > 0 && actorIds.length > 0 && targetIds.length > 0;

  // Combine all conditions: data availability + license + feature flag
  const shouldShowGraph = hasGraphRepresentation && hasRequiredLicense && isGraphFeatureEnabled;
  const {
    isAlert
  } = (0, _use_basic_data_from_details_data.useBasicDataFromDetailsData)(dataFormattedForFieldBrowser);
  return {
    timestamp,
    eventIds,
    actorIds,
    action,
    targetIds,
    shouldShowGraph,
    isAlert
  };
};
exports.useGraphPreview = useGraphPreview;