"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchRelatedCases = void 0;
var _reactQuery = require("@kbn/react-query");
var _react = require("react");
var _kibana = require("../../../../common/lib/kibana");
var _constants = require("../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const QUERY_KEY = 'useFetchRelatedCases';
/**
 * Returns the number of cases related to a document id (and the loading, error statuses as well as the cases count)
 */
const useFetchRelatedCases = ({
  eventId
}) => {
  const {
    services: {
      cases
    }
  } = (0, _kibana.useKibana)();
  const {
    data,
    isLoading,
    isError
  } = (0, _reactQuery.useQuery)([QUERY_KEY, eventId], () => cases.api.getRelatedCases(eventId, {
    owner: _constants.APP_ID
  }), {
    keepPreviousData: true
  });
  return (0, _react.useMemo)(() => ({
    loading: isLoading,
    error: isError,
    data: data || [],
    dataCount: (data === null || data === void 0 ? void 0 : data.length) || 0
  }), [data, isError, isLoading]);
};
exports.useFetchRelatedCases = useFetchRelatedCases;