"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CellActions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _alerts_context = require("../../../../detections/components/alerts_table/alerts_context");
var _context = require("../context");
var _helpers = require("../../../../helpers");
var _constants = require("../../../../app/actions/constants");
var _cell_actions = require("../../../../common/components/cell_actions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/shared/components/cell_actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Security cell action wrapper for document details flyout
 */
const CellActions = ({
  field,
  value,
  isObjectArray,
  children
}) => {
  const {
    scopeId,
    isRulePreview
  } = (0, _context.useDocumentDetailsContext)();
  const {
    alertsTableRef
  } = (0, _alerts_context.useAlertsContext)();
  const data = (0, _react.useMemo)(() => ({
    field,
    value
  }), [field, value]);
  const metadata = (0, _react.useMemo)(() => ({
    scopeId,
    isObjectArray,
    alertsTableRef
  }), [scopeId, isObjectArray, alertsTableRef]);
  const disabledActionTypes = (0, _react.useMemo)(() => isRulePreview ? [_constants.SecurityCellActionType.FILTER, _constants.SecurityCellActionType.TOGGLE_COLUMN] : [], [isRulePreview]);
  return /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
    data: data,
    mode: _cell_actions.CellActionsMode.HOVER_DOWN,
    triggerId: _cell_actions.SecurityCellActionsTrigger.DETAILS_FLYOUT,
    visibleCellActions: 6,
    sourcererScopeId: (0, _helpers.getSourcererScopeId)(scopeId),
    metadata: metadata,
    disabledActionTypes: disabledActionTypes,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 5
    }
  }, children);
};
exports.CellActions = CellActions;
CellActions.displayName = 'CellActions';