"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useExpandSection = void 0;
var _kibana = require("../../../../common/lib/kibana");
var _local_storage = require("../../shared/constants/local_storage");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook to get the expanded state of a section from local storage.
 */
const useExpandSection = ({
  title,
  defaultValue
}) => {
  const {
    storage
  } = (0, _kibana.useKibana)().services;
  const localStorage = storage.get(_local_storage.FLYOUT_STORAGE_KEYS.OVERVIEW_TAB_EXPANDED_SECTIONS);
  const key = title.toLowerCase();
  const expanded = localStorage && localStorage[key] !== undefined ? localStorage[key] : defaultValue;
  return expanded;
};
exports.useExpandSection = useExpandSection;