"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PanelFooter = exports.EVENT = exports.ASK_AI_ASSISTANT = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _elasticAssistant = require("@kbn/elastic-assistant");
var _prompts = require("../../../agent_builder/components/prompts");
var _use_basic_data_from_details_data = require("../shared/hooks/use_basic_data_from_details_data");
var _context = require("../shared/context");
var _use_assistant = require("./hooks/use_assistant");
var _test_ids = require("./test_ids");
var _take_action_button = require("../shared/components/take_action_button");
var _use_agent_builder_availability = require("../../../agent_builder/hooks/use_agent_builder_availability");
var _new_agent_builder_attachment = require("../../../agent_builder/components/new_agent_builder_attachment");
var _use_agent_builder_attachment = require("../../../agent_builder/hooks/use_agent_builder_attachment");
var _helpers = require("../../../assistant/helpers");
var _helpers2 = require("../../../agent_builder/helpers");
var _constants = require("../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/right/footer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ASK_AI_ASSISTANT = exports.ASK_AI_ASSISTANT = _i18n.i18n.translate('xpack.securitySolution.ease.flyout.right.footer.askAIAssistant', {
  defaultMessage: 'Ask AI Assistant'
});
const EVENT = exports.EVENT = _i18n.i18n.translate('xpack.securitySolution.flyout.right.footer.event', {
  defaultMessage: 'Security Event'
});
/**
 * Bottom section of the flyout that contains the take action button
 */
const PanelFooter = ({
  isRulePreview
}) => {
  const {
    dataFormattedForFieldBrowser
  } = (0, _context.useDocumentDetailsContext)();
  const {
    isAlert
  } = (0, _use_basic_data_from_details_data.useBasicDataFromDetailsData)(dataFormattedForFieldBrowser);
  const {
    showAssistant,
    showAssistantOverlay
  } = (0, _use_assistant.useAssistant)({
    dataFormattedForFieldBrowser,
    isAlert
  });
  const {
    isAgentChatExperienceEnabled
  } = (0, _use_agent_builder_availability.useAgentBuilderAvailability)();
  const alertAttachment = (0, _react.useMemo)(() => {
    var _rawData$kibanaAlert;
    const rawData = (0, _helpers.getRawData)(dataFormattedForFieldBrowser !== null && dataFormattedForFieldBrowser !== void 0 ? dataFormattedForFieldBrowser : []);
    return {
      attachmentType: _constants.SecurityAgentBuilderAttachments.alert,
      attachmentData: {
        alert: (0, _helpers2.stringifyEssentialAlertData)(rawData),
        attachmentLabel: isAlert ? (_rawData$kibanaAlert = rawData['kibana.alert.rule.name']) === null || _rawData$kibanaAlert === void 0 ? void 0 : _rawData$kibanaAlert[0] : EVENT
      },
      attachmentPrompt: isAlert ? _prompts.ALERT_ATTACHMENT_PROMPT : _prompts.EVENT_ATTACHMENT_PROMPT
    };
  }, [dataFormattedForFieldBrowser, isAlert]);
  const {
    openAgentBuilderFlyout
  } = (0, _use_agent_builder_attachment.useAgentBuilderAttachment)(alertAttachment);
  if (isRulePreview) return null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    "data-test-subj": _test_ids.FLYOUT_FOOTER_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "transparent",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 11
    }
  }, isAgentChatExperienceEnabled ? /*#__PURE__*/_react.default.createElement(_new_agent_builder_attachment.NewAgentBuilderAttachment, {
    onClick: openAgentBuilderFlyout,
    telemetry: {
      pathway: 'alerts_flyout',
      attachments: ['alert']
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 15
    }
  }) : showAssistant && /*#__PURE__*/_react.default.createElement(_elasticAssistant.NewChatByTitle, {
    showAssistantOverlay: showAssistantOverlay,
    text: ASK_AI_ASSISTANT,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_take_action_button.TakeActionButton, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 13
    }
  })))));
};
exports.PanelFooter = PanelFooter;
PanelFooter.displayName = 'PanelFooter';