"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEcsField = exports.TableFieldNameCell = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _reactField = require("@kbn/react-field");
var _ecs = require("@elastic/ecs");
var _fieldUtils = require("@kbn/field-utils");
var _test_ids = require("./test_ids");
var _helpers = require("../../../../common/components/event_details/helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/right/components/table_field_name_cell.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getEcsField = field => {
  return _ecs.EcsFlat[field];
};
exports.getEcsField = getEcsField;
/**
 * Renders an icon/text couple in the first column of the table
 */
const TableFieldNameCell = exports.TableFieldNameCell = /*#__PURE__*/(0, _react.memo)(({
  dataType,
  field
}) => {
  const ecsField = getEcsField(field);
  const typeName = (0, _fieldUtils.getFieldTypeName)(dataType);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_reactField.FieldIcon, {
    "data-test-subj": _test_ids.FLYOUT_TABLE_FIELD_NAME_CELL_ICON_TEST_ID,
    type: dataType,
    label: typeName,
    scripted: undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    gutterSize: "none",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "eui-textBreakAll",
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: !(0, _lodash.isEmpty)(ecsField === null || ecsField === void 0 ? void 0 : ecsField.description) ? `${ecsField === null || ecsField === void 0 ? void 0 : ecsField.description} ${(0, _helpers.getExampleText)(ecsField === null || ecsField === void 0 ? void 0 : ecsField.example)}` : field,
    delay: "long",
    anchorClassName: "eui-textBreakAll",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    tabIndex: 0,
    size: "xs",
    "data-test-subj": _test_ids.FLYOUT_TABLE_FIELD_NAME_CELL_TEXT_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 15
    }
  }, field))))));
});
TableFieldNameCell.displayName = 'TableFieldNameCell';