"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EventRenderer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _get_row_renderer = require("../../../../timelines/components/timeline/body/renderers/get_row_renderer");
var _renderers = require("../../../../timelines/components/timeline/body/renderers");
var _context = require("../../shared/context");
var _test_ids = require("./test_ids");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/right/components/event_renderer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Event renderer of an event document
 */
const EventRenderer = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    dataAsNestedObject,
    scopeId
  } = (0, _context.useDocumentDetailsContext)();
  const renderer = (0, _react.useMemo)(() => (0, _get_row_renderer.getRowRenderer)({
    data: dataAsNestedObject,
    rowRenderers: _renderers.defaultRowRenderers
  }), [dataAsNestedObject]);
  const rowRenderer = (0, _react.useMemo)(() => renderer ? renderer.renderRow({
    contextId: 'event-details',
    data: dataAsNestedObject,
    scopeId
  }) : null, [renderer, dataAsNestedObject, scopeId]);
  if (!renderer) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": _test_ids.EVENT_RENDERER_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 9
    }
  }, 'Event renderer')), /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
          overflow-x: auto;
          padding-block: ${euiTheme.size.s};
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: 'eui-displayInlineBlock',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 9
    }
  }, rowRenderer)));
};
exports.EventRenderer = EventRenderer;
EventRenderer.displayName = 'EventRenderer';