"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CorrelationsDetails = exports.CORRELATIONS_TAB_ID = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _reactRedux = require("react-redux");
var _test_ids = require("./test_ids");
var _related_alerts_by_session = require("./related_alerts_by_session");
var _related_alerts_by_same_source_event = require("./related_alerts_by_same_source_event");
var _related_cases = require("./related_cases");
var _use_show_related_cases = require("../../shared/hooks/use_show_related_cases");
var _use_show_related_alerts_by_ancestry = require("../../shared/hooks/use_show_related_alerts_by_ancestry");
var _use_show_suppressed_alerts = require("../../shared/hooks/use_show_suppressed_alerts");
var _context = require("../../shared/context");
var _use_show_related_alerts_by_same_source_event = require("../../shared/hooks/use_show_related_alerts_by_same_source_event");
var _use_show_related_alerts_by_session = require("../../shared/hooks/use_show_related_alerts_by_session");
var _related_alerts_by_ancestry = require("./related_alerts_by_ancestry");
var _suppressed_alerts = require("./suppressed_alerts");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _use_security_default_patterns = require("../../../../data_view_manager/hooks/use_security_default_patterns");
var _store = require("../../../../sourcerer/store");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/left/components/correlations_details.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const CORRELATIONS_TAB_ID = exports.CORRELATIONS_TAB_ID = 'correlations';

/**
 * Correlations displayed in the document details expandable flyout left section under the Insights tab
 */
const CorrelationsDetails = () => {
  var _useSelector$patternL, _useSelector;
  const {
    dataAsNestedObject,
    eventId,
    getFieldsData,
    scopeId,
    isRulePreview
  } = (0, _context.useDocumentDetailsContext)();
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const oldSecurityDefaultPatterns = (_useSelector$patternL = (_useSelector = (0, _reactRedux.useSelector)(_store.sourcererSelectors.defaultDataView)) === null || _useSelector === void 0 ? void 0 : _useSelector.patternList) !== null && _useSelector$patternL !== void 0 ? _useSelector$patternL : [];
  const {
    indexPatterns: experimentalSecurityDefaultIndexPatterns
  } = (0, _use_security_default_patterns.useSecurityDefaultPatterns)();
  const securityDefaultPatterns = newDataViewPickerEnabled ? experimentalSecurityDefaultIndexPatterns : oldSecurityDefaultPatterns;
  const {
    show: showAlertsByAncestry,
    documentId
  } = (0, _use_show_related_alerts_by_ancestry.useShowRelatedAlertsByAncestry)({
    getFieldsData,
    dataAsNestedObject,
    eventId,
    isRulePreview
  });
  const {
    show: showSameSourceAlerts,
    originalEventId
  } = (0, _use_show_related_alerts_by_same_source_event.useShowRelatedAlertsBySameSourceEvent)({
    eventId,
    getFieldsData
  });
  const {
    show: showAlertsBySession,
    entityId
  } = (0, _use_show_related_alerts_by_session.useShowRelatedAlertsBySession)({
    getFieldsData
  });
  const showCases = (0, _use_show_related_cases.useShowRelatedCases)({
    getFieldsData
  });
  const {
    show: showSuppressedAlerts,
    alertSuppressionCount
  } = (0, _use_show_suppressed_alerts.useShowSuppressedAlerts)({
    getFieldsData
  });
  const canShowAtLeastOneInsight = showAlertsByAncestry || showSameSourceAlerts || showAlertsBySession || showCases || showSuppressedAlerts;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "none",
    "data-test-subj": _test_ids.CORRELATIONS_DETAILS_TEST_ID,
    color: "transparent",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 5
    }
  }, canShowAtLeastOneInsight ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l",
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 9
    }
  }, showSuppressedAlerts && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_suppressed_alerts.SuppressedAlerts, {
    alertSuppressionCount: alertSuppressionCount,
    dataAsNestedObject: dataAsNestedObject,
    showInvestigateInTimeline: !isRulePreview,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 15
    }
  })), showCases && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_related_cases.RelatedCases, {
    eventId: eventId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 15
    }
  })), showSameSourceAlerts && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_related_alerts_by_same_source_event.RelatedAlertsBySameSourceEvent, {
    originalEventId: originalEventId,
    scopeId: scopeId,
    eventId: eventId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 15
    }
  })), showAlertsBySession && entityId && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_related_alerts_by_session.RelatedAlertsBySession, {
    entityId: entityId,
    scopeId: scopeId,
    eventId: eventId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 15
    }
  })), showAlertsByAncestry && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_related_alerts_by_ancestry.RelatedAlertsByAncestry, {
    indices: securityDefaultPatterns,
    scopeId: scopeId,
    documentId: documentId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 15
    }
  }))) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.insights.correlations.noDataDescription",
    defaultMessage: "No correlations data available.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 9
    }
  }));
};
exports.CorrelationsDetails = CorrelationsDetails;
CorrelationsDetails.displayName = 'CorrelationsDetails';