"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTableTabColumns = exports.FIELD = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _table_field_name_cell = require("../../document_details/right/components/table_field_name_cell");
var _table_tab = require("../../document_details/right/tabs/table_tab");
var _table_field_value_cell = require("../components/table_field_value_cell");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/attack_details/utils/table_tab_columns.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const FIELD = exports.FIELD = _i18n.i18n.translate('xpack.securitySolution.attackDetailsFlyout.table.fieldCellLabel', {
  defaultMessage: 'Field'
});
const VALUE = _i18n.i18n.translate('xpack.securitySolution.attackDetailsFlyout.table.valueCellLabel', {
  defaultMessage: 'Value'
});
/**
 * Returns the columns for the table tab
 */
const getTableTabColumns = ({
  browserFields,
  attackId
}) => [{
  field: 'field',
  name: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 9
    }
  }, FIELD)),
  width: '30%',
  render: (field, data) => {
    return /*#__PURE__*/_react.default.createElement(_table_field_name_cell.TableFieldNameCell, {
      dataType: data.type,
      field: field,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 14
      }
    });
  }
}, {
  field: 'values',
  name: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 9
    }
  }, VALUE)),
  render: (values, data) => {
    const fieldFromBrowserField = (0, _table_tab.getFieldFromBrowserField)(data.field, browserFields);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_table_field_value_cell.TableFieldValueCell, {
      data: data,
      attackId: attackId,
      fieldFromBrowserField: fieldFromBrowserField,
      values: values,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 13
      }
    })));
  }
}];
exports.getTableTabColumns = getTableTabColumns;