"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.routes = void 0;
var _react = _interopRequireDefault(require("react"));
var _pages = require("./users/pages");
var _pages2 = require("./hosts/pages");
var _pages3 = require("./network/pages");
var _types = require("../app/types");
var _constants = require("../../common/constants");
var _plugin_template_wrapper = require("../common/components/plugin_template_wrapper");
var _landing = require("./landing");
var _security_route_page_wrapper = require("../common/components/security_route_page_wrapper");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/routes.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ExploreLanding = () => /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 21,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_landing.ExploreLandingPage, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 22,
    columnNumber: 5
  }
}));
const NetworkRoutes = () => /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 27,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_pages3.NetworkContainer, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 28,
    columnNumber: 5
  }
}));
const UsersRoutes = () => /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 33,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_pages.UsersContainer, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 34,
    columnNumber: 5
  }
}));
const HostsRoutes = () => /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 39,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_pages2.HostsContainer, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 40,
    columnNumber: 5
  }
}));
const routes = exports.routes = [{
  path: _constants.EXPLORE_PATH,
  exact: true,
  component: (0, _security_route_page_wrapper.withSecurityRoutePageWrapper)(ExploreLanding, _types.SecurityPageName.exploreLanding, {
    omitSpyRoute: true
  })
}, {
  path: _constants.NETWORK_PATH,
  component: (0, _security_route_page_wrapper.withSecurityRoutePageWrapper)(NetworkRoutes, _types.SecurityPageName.network, {
    omitSpyRoute: true
  })
}, {
  path: _constants.USERS_PATH,
  component: (0, _security_route_page_wrapper.withSecurityRoutePageWrapper)(UsersRoutes, _types.SecurityPageName.users, {
    omitSpyRoute: true
  })
}, {
  path: _constants.HOSTS_PATH,
  component: (0, _security_route_page_wrapper.withSecurityRoutePageWrapper)(HostsRoutes, _types.SecurityPageName.hosts, {
    omitSpyRoute: true
  })
}];