"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SourceDestinationWithArrows = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _source_destination_arrows = require("./source_destination_arrows");
var _source_destination_ip = require("./source_destination_ip");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/network/components/source_destination/source_destination_with_arrows.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Visualizes the communication between a source and a destination by
 * providing an interactive (draggable, hyperlinked) visualization,
 * which contains both the source and destination. (See
 * `SourceDestinationIp` ) for details on how the source and destination
 * are visually represented.
 */
const SourceDestinationWithArrows = exports.SourceDestinationWithArrows = /*#__PURE__*/_react.default.memo(({
  contextId,
  destinationBytes,
  destinationGeoContinentName,
  destinationGeoCountryName,
  destinationGeoCountryIsoCode,
  destinationGeoRegionName,
  destinationGeoCityName,
  destinationIp,
  destinationPackets,
  destinationPort,
  eventId,
  sourceBytes,
  sourceGeoContinentName,
  sourceGeoCountryName,
  sourceGeoCountryIsoCode,
  sourceGeoRegionName,
  sourceGeoCityName,
  sourcePackets,
  sourceIp,
  sourcePort,
  scopeId
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  justifyContent: "center",
  gutterSize: "none",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 46,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 47,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_source_destination_ip.SourceDestinationIp, {
  scopeId: scopeId,
  contextId: contextId,
  destinationGeoContinentName: destinationGeoContinentName,
  destinationGeoCountryName: destinationGeoCountryName,
  destinationGeoCountryIsoCode: destinationGeoCountryIsoCode,
  destinationGeoRegionName: destinationGeoRegionName,
  destinationGeoCityName: destinationGeoCityName,
  destinationIp: destinationIp,
  destinationPort: destinationPort,
  eventId: eventId,
  sourceGeoContinentName: sourceGeoContinentName,
  sourceGeoCountryName: sourceGeoCountryName,
  sourceGeoCountryIsoCode: sourceGeoCountryIsoCode,
  sourceGeoRegionName: sourceGeoRegionName,
  sourceGeoCityName: sourceGeoCityName,
  sourceIp: sourceIp,
  sourcePort: sourcePort,
  type: "source",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 48,
    columnNumber: 9
  }
})), /*#__PURE__*/_react.default.createElement(_source_destination_arrows.SourceDestinationArrows, {
  scopeId: scopeId,
  contextId: contextId,
  destinationBytes: destinationBytes,
  destinationPackets: destinationPackets,
  eventId: eventId,
  sourceBytes: sourceBytes,
  sourcePackets: sourcePackets,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 70,
    columnNumber: 7
  }
}), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 80,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_source_destination_ip.SourceDestinationIp, {
  scopeId: scopeId,
  contextId: contextId,
  destinationGeoContinentName: destinationGeoContinentName,
  destinationGeoCountryName: destinationGeoCountryName,
  destinationGeoCountryIsoCode: destinationGeoCountryIsoCode,
  destinationGeoRegionName: destinationGeoRegionName,
  destinationGeoCityName: destinationGeoCityName,
  destinationIp: destinationIp,
  destinationPort: destinationPort,
  eventId: eventId,
  sourceGeoContinentName: sourceGeoContinentName,
  sourceGeoCountryName: sourceGeoCountryName,
  sourceGeoCountryIsoCode: sourceGeoCountryIsoCode,
  sourceGeoRegionName: sourceGeoRegionName,
  sourceGeoCityName: sourceGeoCityName,
  sourceIp: sourceIp,
  sourcePort: sourcePort,
  type: "destination",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 81,
    columnNumber: 9
  }
}))));
SourceDestinationWithArrows.displayName = 'SourceDestinationWithArrows';