"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetUniquePrivateIpsStatItems = exports.NetworkKpiUniquePrivateIps = exports.ID = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _kpi_unique_private_ips_source_metric = require("../../../../../common/components/visualization_actions/lens_attributes/network/kpi_unique_private_ips_source_metric");
var _kpi_unique_private_ips_destination_metric = require("../../../../../common/components/visualization_actions/lens_attributes/network/kpi_unique_private_ips_destination_metric");
var _kpi_unique_private_ips_area = require("../../../../../common/components/visualization_actions/lens_attributes/network/kpi_unique_private_ips_area");
var _kpi_unique_private_ips_bar = require("../../../../../common/components/visualization_actions/lens_attributes/network/kpi_unique_private_ips_bar");
var _kpi = require("../../../../components/kpi");
var _unique_ips_palette = require("../../../../../common/components/visualization_actions/lens_attributes/common/utils/unique_ips_palette");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/network/components/kpi_network/unique_private_ips/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ID = exports.ID = 'networkKpiUniquePrivateIpsQuery';
const useGetUniquePrivateIpsStatItems = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return (0, _react.useMemo)(() => [{
    key: 'uniqueIps',
    fields: [{
      key: 'uniqueSourcePrivateIps',
      name: i18n.SOURCE_CHART_LABEL,
      description: i18n.SOURCE_UNIT_LABEL,
      color: (0, _unique_ips_palette.getSourceIpColor)(euiTheme),
      icon: 'visMapCoordinate',
      lensAttributes: _kpi_unique_private_ips_source_metric.kpiUniquePrivateIpsSourceMetricLensAttributes
    }, {
      key: 'uniqueDestinationPrivateIps',
      name: i18n.DESTINATION_CHART_LABEL,
      description: i18n.DESTINATION_UNIT_LABEL,
      color: (0, _unique_ips_palette.getDestinationIpColor)(euiTheme),
      icon: 'visMapCoordinate',
      lensAttributes: _kpi_unique_private_ips_destination_metric.kpiUniquePrivateIpsDestinationMetricLensAttributes
    }],
    description: i18n.UNIQUE_PRIVATE_IPS,
    enableAreaChart: true,
    enableBarChart: true,
    getAreaChartLensAttributes: _kpi_unique_private_ips_area.getKpiUniquePrivateIpsAreaLensAttributes,
    getBarChartLensAttributes: _kpi_unique_private_ips_bar.getKpiUniquePrivateIpsBarLensAttributes
  }], [euiTheme]);
};
exports.useGetUniquePrivateIpsStatItems = useGetUniquePrivateIpsStatItems;
const NetworkKpiUniquePrivateIpsComponent = ({
  from,
  to
}) => {
  const uniquePrivateIpsStatItems = useGetUniquePrivateIpsStatItems();
  return /*#__PURE__*/_react.default.createElement(_kpi.KpiBaseComponent, {
    id: ID,
    statItems: uniquePrivateIpsStatItems,
    from: from,
    to: to,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 10
    }
  });
};
const NetworkKpiUniquePrivateIps = exports.NetworkKpiUniquePrivateIps = /*#__PURE__*/_react.default.memo(NetworkKpiUniquePrivateIpsComponent);