"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SOURCE_LAYER = exports.SOURCE_IP = exports.SOURCE_DOMAIN = exports.SOURCE = exports.SERVER_LAYER = exports.SERVER_IP = exports.SERVER_DOMAIN = exports.SERVER = exports.MAP_TOOL_TIP_FEATURES_FOOTER = exports.MAP_TOOL_TIP_ERROR = exports.LOCATION = exports.LINE_LAYER = exports.HOST = exports.ERROR_TITLE = exports.ERROR_CREATING_EMBEDDABLE = exports.ERROR_BUTTON = exports.EMBEDDABLE_HEADER_TITLE = exports.EMBEDDABLE_HEADER_HELP = exports.DESTINATION_LAYER = exports.DESTINATION_IP = exports.DESTINATION_DOMAIN = exports.DESTINATION = exports.CLIENT_LAYER = exports.CLIENT_IP = exports.CLIENT_DOMAIN = exports.CLIENT = exports.ASN = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EMBEDDABLE_HEADER_TITLE = exports.EMBEDDABLE_HEADER_TITLE = _i18n.i18n.translate('xpack.securitySolution.components.embeddables.embeddedMap.embeddableHeaderTitle', {
  defaultMessage: 'Network map'
});
const EMBEDDABLE_HEADER_HELP = exports.EMBEDDABLE_HEADER_HELP = _i18n.i18n.translate('xpack.securitySolution.components.embeddables.embeddedMap.embeddableHeaderHelp', {
  defaultMessage: 'Map configuration help'
});
const SOURCE_LAYER = exports.SOURCE_LAYER = _i18n.i18n.translate('xpack.securitySolution.components.embeddables.embeddedMap.sourceLayerLabel', {
  defaultMessage: 'Source Point'
});
const DESTINATION_LAYER = exports.DESTINATION_LAYER = _i18n.i18n.translate('xpack.securitySolution.components.embeddables.embeddedMap.destinationLayerLabel', {
  defaultMessage: 'Destination Point'
});
const CLIENT_LAYER = exports.CLIENT_LAYER = _i18n.i18n.translate('xpack.securitySolution.components.embeddables.embeddedMap.clientLayerLabel', {
  defaultMessage: 'Client Point'
});
const SERVER_LAYER = exports.SERVER_LAYER = _i18n.i18n.translate('xpack.securitySolution.components.embeddables.embeddedMap.serverLayerLabel', {
  defaultMessage: 'Server Point'
});
const LINE_LAYER = exports.LINE_LAYER = _i18n.i18n.translate('xpack.securitySolution.components.embeddables.embeddedMap.lineLayerLabel', {
  defaultMessage: 'Line'
});
const ERROR_CREATING_EMBEDDABLE = exports.ERROR_CREATING_EMBEDDABLE = _i18n.i18n.translate('xpack.securitySolution.components.embeddables.embeddedMap.errorCreatingMapEmbeddableTitle', {
  defaultMessage: 'Error creating Map Embeddable'
});
const ERROR_TITLE = exports.ERROR_TITLE = _i18n.i18n.translate('xpack.securitySolution.components.embeddables.indexPatternsMissingPrompt.errorTitle', {
  defaultMessage: 'Required index patterns not configured'
});
const ERROR_BUTTON = exports.ERROR_BUTTON = _i18n.i18n.translate('xpack.securitySolution.components.embeddables.indexPatternsMissingPrompt.errorButtonLabel', {
  defaultMessage: 'Configure index patterns'
});
const MAP_TOOL_TIP_ERROR = exports.MAP_TOOL_TIP_ERROR = _i18n.i18n.translate('xpack.securitySolution.components.embeddables.mapToolTip.errorTitle', {
  defaultMessage: 'Error loading map features'
});
const MAP_TOOL_TIP_FEATURES_FOOTER = (currentFeature, totalFeatures) => _i18n.i18n.translate('xpack.securitySolution.components.embeddables.mapToolTip.footerLabel', {
  values: {
    currentFeature,
    totalFeatures
  },
  defaultMessage: '{currentFeature} of {totalFeatures} {totalFeatures, plural, =1 {feature} other {features}}'
});
exports.MAP_TOOL_TIP_FEATURES_FOOTER = MAP_TOOL_TIP_FEATURES_FOOTER;
const HOST = exports.HOST = _i18n.i18n.translate('xpack.securitySolution.components.embeddables.mapToolTip.pointContent.hostTitle', {
  defaultMessage: 'Host'
});
const SOURCE_IP = exports.SOURCE_IP = _i18n.i18n.translate('xpack.securitySolution.components.embeddables.mapToolTip.pointContent.sourceIPTitle', {
  defaultMessage: 'Source IP'
});
const DESTINATION_IP = exports.DESTINATION_IP = _i18n.i18n.translate('xpack.securitySolution.components.embeddables.mapToolTip.pointContent.destinationIPTitle', {
  defaultMessage: 'Destination IP'
});
const CLIENT_IP = exports.CLIENT_IP = _i18n.i18n.translate('xpack.securitySolution.components.embeddables.mapToolTip.pointContent.clientIPTitle', {
  defaultMessage: 'Client IP'
});
const SERVER_IP = exports.SERVER_IP = _i18n.i18n.translate('xpack.securitySolution.components.embeddables.mapToolTip.pointContent.serverIPTitle', {
  defaultMessage: 'Server IP'
});
const SOURCE_DOMAIN = exports.SOURCE_DOMAIN = _i18n.i18n.translate('xpack.securitySolution.components.embeddables.mapToolTip.pointContent.sourceDomainTitle', {
  defaultMessage: 'Source domain'
});
const DESTINATION_DOMAIN = exports.DESTINATION_DOMAIN = _i18n.i18n.translate('xpack.securitySolution.components.embeddables.mapToolTip.pointContent.destinationDomainTitle', {
  defaultMessage: 'Destination domain'
});
const CLIENT_DOMAIN = exports.CLIENT_DOMAIN = _i18n.i18n.translate('xpack.securitySolution.components.embeddables.mapToolTip.pointContent.clientDomainTitle', {
  defaultMessage: 'Client domain'
});
const SERVER_DOMAIN = exports.SERVER_DOMAIN = _i18n.i18n.translate('xpack.securitySolution.components.embeddables.mapToolTip.pointContent.serverDomainTitle', {
  defaultMessage: 'Server domain'
});
const LOCATION = exports.LOCATION = _i18n.i18n.translate('xpack.securitySolution.components.embeddables.mapToolTip.pointContent.locationTitle', {
  defaultMessage: 'Location'
});
const ASN = exports.ASN = _i18n.i18n.translate('xpack.securitySolution.components.embeddables.mapToolTip.pointContent.asnTitle', {
  defaultMessage: 'ASN'
});
const SOURCE = exports.SOURCE = _i18n.i18n.translate('xpack.securitySolution.components.embeddables.mapToolTip.lineContent.sourceLabel', {
  defaultMessage: 'Source'
});
const DESTINATION = exports.DESTINATION = _i18n.i18n.translate('xpack.securitySolution.components.embeddables.mapToolTip.lineContent.destinationLabel', {
  defaultMessage: 'Destination'
});
const CLIENT = exports.CLIENT = _i18n.i18n.translate('xpack.securitySolution.components.embeddables.mapToolTip.lineContent.clientLabel', {
  defaultMessage: 'Client'
});
const SERVER = exports.SERVER = _i18n.i18n.translate('xpack.securitySolution.components.embeddables.mapToolTip.lineContent.serverLabel', {
  defaultMessage: 'Server'
});