"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NETWORK_MAP_VISIBLE = exports.EmbeddedMapComponent = exports.EmbeddedMap = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactReversePortal = require("react-reverse-portal");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _react2 = require("@emotion/react");
var _fp = require("lodash/fp");
var _constants = require("../../../../data_view_manager/constants");
var _helpers = require("../../../../detections/components/alerts_table/helpers");
var _use_app_toasts = require("../../../../common/hooks/use_app_toasts");
var _fields = require("../../../containers/fields");
var _embeddable = require("./embeddable");
var _index_patterns_missing_prompt = require("./index_patterns_missing_prompt");
var _map_tool_tip = require("./map_tool_tip/map_tool_tip");
var i18n = _interopRequireWildcard(require("./translations"));
var _kibana = require("../../../../common/lib/kibana");
var _map_config = require("./map_config");
var _store = require("../../../../sourcerer/store");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _use_data_view = require("../../../../data_view_manager/hooks/use_data_view");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/network/components/embeddables/embedded_map.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// embedded map v2
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NETWORK_MAP_VISIBLE = exports.NETWORK_MAP_VISIBLE = 'network_map_visbile';
const EmbeddableMapRatioHolder = _styled.default.div`
  .mapToolbarOverlay__button {
    display: none;
  }
  ${({
  maintainRatio,
  theme: {
    euiTheme
  }
}) => maintainRatio && (0, _react2.css)`
      padding-top: calc(3 / 4 * 100%); /* 4:3 (standard) ratio */
      position: relative;

      @media only screen and (min-width: ${euiTheme.breakpoint.m}) {
        padding-top: calc(9 / 32 * 100%); /* 32:9 (ultra widescreen) ratio */
      }
      @media only screen and (min-width: 1441px) and (min-height: 901px) {
        padding-top: calc(9 / 21 * 100%); /* 21:9 (ultrawide) ratio */
      }

      .embPanel {
        bottom: 0;
        left: 0;
        position: absolute;
        right: 0;
        top: 0;
      }
    `}
`;
const StyledEuiText = (0, _styled.default)(_eui.EuiText)`
  margin-right: 16px;
`;
const StyledEuiAccordion = (0, _styled.default)(_eui.EuiAccordion)`
  & .euiAccordion__triggerWrapper {
    padding: 16px;
  }
`;
EmbeddableMapRatioHolder.displayName = 'EmbeddableMapRatioHolder';
const EmbeddableMapWrapper = _styled.default.div`
  position: relative;
`;
const EmbeddableMap = _styled.default.div`
  height: 100%;
  width: 100%;
  position: absolute;
  top: 0;
`;
const EmbeddedMapComponent = ({
  endDate,
  filters,
  query,
  setQuery,
  startDate
}) => {
  var _storage$get;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    services
  } = (0, _kibana.useKibana)();
  const {
    storage
  } = services;
  const [isError, setIsError] = (0, _react.useState)(false);
  const [isIndexError, setIsIndexError] = (0, _react.useState)(false);
  const [storageValue, setStorageValue] = (0, _react.useState)((_storage$get = storage.get(NETWORK_MAP_VISIBLE)) !== null && _storage$get !== void 0 ? _storage$get : true);
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const {
    dataView: experimentalDataView
  } = (0, _use_data_view.useDataView)(_constants.PageScope.explore);
  // TODO This can be completely removed once we switch the newDataViewPickerEnabled on
  const kibanaDataViews = (0, _reactRedux.useSelector)(_store.sourcererSelectors.kibanaDataViews);
  const selectedPatterns = (0, _reactRedux.useSelector)(state => {
    return _store.sourcererSelectors.sourcererScopeSelectedPatterns(state, _constants.PageScope.default);
  });
  const isFieldInIndexPattern = (0, _fields.useIsFieldInIndexPattern)();
  const [layerList, setLayerList] = (0, _react.useState)([]);
  const [availableDataViews, setAvailableDataViews] = (0, _react.useState)([]);
  const experimentalDataViewLayerList = (0, _react.useMemo)(() => experimentalDataView.id && experimentalDataView.getIndexPattern() ? (0, _map_config.getLayerList)({
    euiTheme
  }, [{
    id: experimentalDataView.id,
    title: experimentalDataView.getIndexPattern()
  }]) : [], [euiTheme, experimentalDataView]);

  // TODO This can be completely removed once we switch the newDataViewPickerEnabled on
  (0, _react.useEffect)(() => {
    if (newDataViewPickerEnabled) return;
    let canceled = false;
    const fetchData = async () => {
      try {
        const apiResponse = await Promise.all(availableDataViews.map(async ({
          title
        }) => isFieldInIndexPattern(title)));
        // ensures only index patterns with maps fields are passed
        const goodDataViews = availableDataViews.filter((_, i) => {
          var _apiResponse$i;
          return (_apiResponse$i = apiResponse[i]) !== null && _apiResponse$i !== void 0 ? _apiResponse$i : false;
        });
        if (!canceled) {
          setLayerList((0, _map_config.getLayerList)({
            euiTheme
          }, goodDataViews));
        }
      } catch (e) {
        if (!canceled) {
          setLayerList([]);
          addError(e, {
            title: i18n.ERROR_CREATING_EMBEDDABLE
          });
          setIsError(true);
        }
      }
    };
    if (availableDataViews.length) {
      fetchData();
    }
    return () => {
      canceled = true;
    };
  }, [addError, availableDataViews, euiTheme, isFieldInIndexPattern, newDataViewPickerEnabled]);

  // TODO This can be completely removed once we switch the newDataViewPickerEnabled on
  (0, _react.useEffect)(() => {
    if (newDataViewPickerEnabled) return;
    const dataViews = kibanaDataViews.filter(dataView => selectedPatterns.includes(dataView.title));
    if (selectedPatterns.length > 0 && dataViews.length === 0) {
      setIsIndexError(true);
    }
    setAvailableDataViews(prevViews => (0, _fp.isEqual)(prevViews, dataViews) ? prevViews : dataViews);
  }, [kibanaDataViews, selectedPatterns, newDataViewPickerEnabled]);

  // This portalNode provided by react-reverse-portal allows us re-parent the MapToolTip within our
  // own component tree instead of the embeddables (default). This is necessary to have access to
  // the Redux store, theme provider, etc, which is required to register and un-register the draggable
  // Search InPortal/OutPortal for implementation touch points
  const portalNode = _react.default.useMemo(() => (0, _reactReversePortal.createHtmlPortalNode)(), []);
  const appliedFilters = (0, _react.useMemo)(() => {
    return [...filters, ...(0, _helpers.buildTimeRangeFilter)(startDate, endDate)];
  }, [filters, startDate, endDate]);
  const setDefaultMapVisibility = (0, _react.useCallback)(isOpen => {
    storage.set(NETWORK_MAP_VISIBLE, isOpen);
    setStorageValue(isOpen);
  }, [storage]);
  const content = !storageValue ? null : /*#__PURE__*/_react.default.createElement(_embeddable.Embeddable, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_reactReversePortal.InPortal, {
    node: portalNode,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_map_tool_tip.MapToolTip, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(EmbeddableMapWrapper, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(EmbeddableMapRatioHolder, {
    className: "siemEmbeddable__map",
    maintainRatio: !isIndexError,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 9
    }
  }), isIndexError ? /*#__PURE__*/_react.default.createElement(_index_patterns_missing_prompt.IndexPatternsMissingPrompt, {
    "data-test-subj": "missing-prompt",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(EmbeddableMap, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(services.maps.Map, {
    // eslint-disable-next-line react/display-name
    getTooltipRenderer: () => tooltipProps => /*#__PURE__*/_react.default.createElement(_reactReversePortal.OutPortal, (0, _extends2.default)({
      node: portalNode
    }, tooltipProps, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 221,
        columnNumber: 17
      }
    })),
    mapCenter: {
      lon: -1.05469,
      lat: 15.96133,
      zoom: 1
    },
    layerList: newDataViewPickerEnabled ? experimentalDataViewLayerList : layerList,
    filters: appliedFilters,
    query: query,
    onApiAvailable: api => {
      // Wire up to app refresh action
      setQuery({
        id: 'embeddedMap',
        // Scope to page type if using map elsewhere
        inspect: null,
        loading: false,
        refetch: () => api.reload()
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 13
    }
  }))));
  return isError ? null : /*#__PURE__*/_react.default.createElement(StyledEuiAccordion, {
    "data-test-subj": "EmbeddedMapComponent",
    onToggle: setDefaultMapVisibility,
    id: 'network-map',
    arrowDisplay: "right",
    arrowProps: {
      color: 'primary',
      'data-test-subj': `${storageValue}-toggle-network-map`
    },
    buttonContent: /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 252,
        columnNumber: 22
      }
    }, i18n.EMBEDDABLE_HEADER_TITLE),
    extraAction: /*#__PURE__*/_react.default.createElement(StyledEuiText, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 254,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: `${services.docLinks.links.siem.networkMap}`,
      target: "_blank",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 255,
        columnNumber: 11
      }
    }, i18n.EMBEDDABLE_HEADER_HELP)),
    paddingSize: "none",
    initialIsOpen: storageValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 5
    }
  }, content);
};
exports.EmbeddedMapComponent = EmbeddedMapComponent;
EmbeddedMapComponent.displayName = 'EmbeddedMapComponent';
const EmbeddedMap = exports.EmbeddedMap = /*#__PURE__*/_react.default.memo(EmbeddedMapComponent);
EmbeddedMap.displayName = 'EmbeddedMap';