"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.exploreLinks = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("@kbn/security-solution-features/constants");
var _constants2 = require("../../common/constants");
var _translations = require("../app/translations");
var _hosts_page = _interopRequireDefault(require("../common/images/hosts_page.png"));
var _users_page = _interopRequireDefault(require("../common/images/users_page.png"));
var _network_page = _interopRequireDefault(require("../common/images/network_page.png"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const networkLinks = {
  id: _constants2.SecurityPageName.network,
  title: _translations.NETWORK,
  landingImage: _network_page.default,
  description: _i18n.i18n.translate('xpack.securitySolution.appLinks.network.description', {
    defaultMessage: 'Provides key activity metrics in an interactive map as well as event tables that enable interaction with the Timeline.'
  }),
  path: _constants2.NETWORK_PATH,
  globalSearchKeywords: [_i18n.i18n.translate('xpack.securitySolution.appLinks.network', {
    defaultMessage: 'Network'
  })],
  capabilities: [_constants.SECURITY_UI_SHOW_PRIVILEGE],
  links: [{
    id: _constants2.SecurityPageName.networkFlows,
    title: _i18n.i18n.translate('xpack.securitySolution.appLinks.network.flows', {
      defaultMessage: 'Flows'
    }),
    path: `${_constants2.NETWORK_PATH}/flows`
  }, {
    id: _constants2.SecurityPageName.networkDns,
    title: _i18n.i18n.translate('xpack.securitySolution.appLinks.network.dns', {
      defaultMessage: 'DNS'
    }),
    path: `${_constants2.NETWORK_PATH}/dns`
  }, {
    id: _constants2.SecurityPageName.networkHttp,
    title: _i18n.i18n.translate('xpack.securitySolution.appLinks.network.http', {
      defaultMessage: 'HTTP'
    }),
    path: `${_constants2.NETWORK_PATH}/http`
  }, {
    id: _constants2.SecurityPageName.networkTls,
    title: _i18n.i18n.translate('xpack.securitySolution.appLinks.network.tls', {
      defaultMessage: 'TLS'
    }),
    path: `${_constants2.NETWORK_PATH}/tls`
  }, {
    id: _constants2.SecurityPageName.networkAnomalies,
    title: _i18n.i18n.translate('xpack.securitySolution.appLinks.hosts.anomalies', {
      defaultMessage: 'Anomalies'
    }),
    capabilities: ['ml.canGetJobs'],
    path: `${_constants2.NETWORK_PATH}/anomalies`,
    licenseType: 'gold'
  }, {
    id: _constants2.SecurityPageName.networkEvents,
    title: _i18n.i18n.translate('xpack.securitySolution.appLinks.network.events', {
      defaultMessage: 'Events'
    }),
    path: `${_constants2.NETWORK_PATH}/events`
  }]
};
const usersLinks = {
  id: _constants2.SecurityPageName.users,
  title: _translations.USERS,
  landingImage: _users_page.default,
  description: _i18n.i18n.translate('xpack.securitySolution.appLinks.users.description', {
    defaultMessage: 'A comprehensive overview of user data that enables understanding of authentication and user behavior within your environment.'
  }),
  path: _constants2.USERS_PATH,
  globalSearchKeywords: [_i18n.i18n.translate('xpack.securitySolution.appLinks.users', {
    defaultMessage: 'Users'
  })],
  capabilities: [_constants.SECURITY_UI_SHOW_PRIVILEGE],
  links: [{
    id: _constants2.SecurityPageName.usersAll,
    title: _i18n.i18n.translate('xpack.securitySolution.appLinks.users.allUsers', {
      defaultMessage: 'All users'
    }),
    path: `${_constants2.USERS_PATH}/allUsers`
  }, {
    id: _constants2.SecurityPageName.usersAuthentications,
    title: _i18n.i18n.translate('xpack.securitySolution.appLinks.users.authentications', {
      defaultMessage: 'Authentications'
    }),
    path: `${_constants2.USERS_PATH}/authentications`
  }, {
    id: _constants2.SecurityPageName.usersAnomalies,
    title: _i18n.i18n.translate('xpack.securitySolution.appLinks.users.anomalies', {
      defaultMessage: 'Anomalies'
    }),
    capabilities: ['ml.canGetJobs'],
    path: `${_constants2.USERS_PATH}/anomalies`,
    licenseType: 'gold'
  }, {
    id: _constants2.SecurityPageName.usersRisk,
    title: _i18n.i18n.translate('xpack.securitySolution.appLinks.users.risk', {
      defaultMessage: 'User risk'
    }),
    path: `${_constants2.USERS_PATH}/userRisk`
  }, {
    id: _constants2.SecurityPageName.usersEvents,
    title: _i18n.i18n.translate('xpack.securitySolution.appLinks.users.events', {
      defaultMessage: 'Events'
    }),
    path: `${_constants2.USERS_PATH}/events`
  }]
};
const hostsLinks = {
  id: _constants2.SecurityPageName.hosts,
  title: _translations.HOSTS,
  landingImage: _hosts_page.default,
  description: _i18n.i18n.translate('xpack.securitySolution.landing.threatHunting.hostsDescription', {
    defaultMessage: 'A comprehensive overview of all hosts and host-related security events.'
  }),
  path: _constants2.HOSTS_PATH,
  globalSearchKeywords: [_i18n.i18n.translate('xpack.securitySolution.appLinks.hosts', {
    defaultMessage: 'Hosts'
  })],
  capabilities: [_constants.SECURITY_UI_SHOW_PRIVILEGE],
  links: [{
    id: _constants2.SecurityPageName.hostsAll,
    title: _i18n.i18n.translate('xpack.securitySolution.appLinks.hosts.allHosts', {
      defaultMessage: 'All hosts'
    }),
    path: `${_constants2.HOSTS_PATH}/allHosts`,
    isBeta: false
  }, {
    id: _constants2.SecurityPageName.hostsUncommonProcesses,
    title: _i18n.i18n.translate('xpack.securitySolution.appLinks.hosts.uncommonProcesses', {
      defaultMessage: 'Uncommon Processes'
    }),
    path: `${_constants2.HOSTS_PATH}/uncommonProcesses`
  }, {
    id: _constants2.SecurityPageName.hostsAnomalies,
    title: _i18n.i18n.translate('xpack.securitySolution.appLinks.hosts.anomalies', {
      defaultMessage: 'Anomalies'
    }),
    capabilities: ['ml.canGetJobs'],
    path: `${_constants2.HOSTS_PATH}/anomalies`,
    licenseType: 'gold'
  }, {
    id: _constants2.SecurityPageName.hostsEvents,
    title: _i18n.i18n.translate('xpack.securitySolution.appLinks.hosts.events', {
      defaultMessage: 'Events'
    }),
    path: `${_constants2.HOSTS_PATH}/events`
  }, {
    id: _constants2.SecurityPageName.hostsRisk,
    title: _i18n.i18n.translate('xpack.securitySolution.appLinks.hosts.risk', {
      defaultMessage: 'Host risk'
    }),
    path: `${_constants2.HOSTS_PATH}/hostRisk`
  }, {
    id: _constants2.SecurityPageName.hostsSessions,
    title: _i18n.i18n.translate('xpack.securitySolution.appLinks.hosts.sessions', {
      defaultMessage: 'Sessions'
    }),
    path: `${_constants2.HOSTS_PATH}/sessions`,
    isBeta: false,
    licenseType: 'enterprise'
  }]
};
const exploreLinks = exports.exploreLinks = {
  id: _constants2.SecurityPageName.exploreLanding,
  title: _translations.EXPLORE,
  path: _constants2.EXPLORE_PATH,
  globalNavPosition: 8,
  capabilities: [[_constants.SECURITY_UI_SHOW_PRIVILEGE, `${_constants2.SECURITY_FEATURE_ID}.detections`]],
  globalSearchKeywords: [_i18n.i18n.translate('xpack.securitySolution.appLinks.explore', {
    defaultMessage: 'Explore'
  })],
  links: [hostsLinks, networkLinks, usersLinks],
  hideTimeline: true,
  skipUrlState: true
};