"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExploreLandingPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _landing_links = require("@kbn/security-solution-navigation/landing_links");
var _types = require("../app/types");
var _header_page = require("../common/components/header_page");
var _nav_links = require("../common/links/nav_links");
var _page_wrapper = require("../common/components/page_wrapper");
var _spy_routes = require("../common/utils/route/spy_routes");
var _trackers = require("../common/lib/telemetry/trackers");
var _global_query_string = require("../common/utils/global_query_string");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/landing.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const EXPLORE_PAGE_TITLE = _i18n.i18n.translate('xpack.securitySolution.explore.landing.pageTitle', {
  defaultMessage: 'Explore'
});
const ExploreLandingPage = () => {
  var _useRootNavLink;
  const {
    links = []
  } = (_useRootNavLink = (0, _nav_links.useRootNavLink)(_types.SecurityPageName.exploreLanding)) !== null && _useRootNavLink !== void 0 ? _useRootNavLink : {};
  const urlState = (0, _global_query_string.useGlobalQueryString)();
  return /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
    title: EXPLORE_PAGE_TITLE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_landing_links.LandingLinksImages, {
    items: links,
    urlState: urlState,
    onLinkClick: _trackers.trackLandingLinkClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _types.SecurityPageName.exploreLanding,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 7
    }
  }));
};
exports.ExploreLandingPage = ExploreLandingPage;