"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.uncommonProcessesSelector = exports.hostsSelector = exports.hostsAnomaliesJobIdFilterSelector = exports.hostsAnomaliesIntervalSelector = exports.hostRiskScoreSeverityFilterSelector = exports.hostRiskScoreSelector = exports.authenticationsSelector = void 0;
var _fp = require("lodash/fp");
var _reselect = require("reselect");
var _model = require("./model");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const selectHosts = (state, hostsType) => (0, _fp.get)(hostsType, state.hosts);
const authenticationsSelector = () => (0, _reselect.createSelector)(selectHosts, hosts => hosts.queries.authentications);
exports.authenticationsSelector = authenticationsSelector;
const hostsSelector = () => (0, _reselect.createSelector)(selectHosts, hosts => hosts.queries[_model.HostsTableType.hosts]);
exports.hostsSelector = hostsSelector;
const hostRiskScoreSelector = () => (0, _reselect.createSelector)(selectHosts, hosts => hosts.queries[_model.HostsTableType.risk]);
exports.hostRiskScoreSelector = hostRiskScoreSelector;
const hostRiskScoreSeverityFilterSelector = () => (0, _reselect.createSelector)(selectHosts, hosts => hosts.queries[_model.HostsTableType.risk].severitySelection);
exports.hostRiskScoreSeverityFilterSelector = hostRiskScoreSeverityFilterSelector;
const uncommonProcessesSelector = () => (0, _reselect.createSelector)(selectHosts, hosts => hosts.queries.uncommonProcesses);
exports.uncommonProcessesSelector = uncommonProcessesSelector;
const hostsAnomaliesJobIdFilterSelector = () => (0, _reselect.createSelector)(selectHosts, hosts => hosts.queries[_model.HostsTableType.anomalies].jobIdSelection);
exports.hostsAnomaliesJobIdFilterSelector = hostsAnomaliesJobIdFilterSelector;
const hostsAnomaliesIntervalSelector = () => (0, _reselect.createSelector)(selectHosts, hosts => hosts.queries[_model.HostsTableType.anomalies].intervalSelection);
exports.hostsAnomaliesIntervalSelector = hostsAnomaliesIntervalSelector;