"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostsTabs = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _model = require("../store/model");
var _anomalies_query_tab_body = require("../../../common/containers/anomalies/anomalies_query_tab_body");
var _anomalies_host_table = require("../../../common/components/ml/tables/anomalies_host_table");
var _events_tab = require("../../../common/components/events_tab");
var _constants = require("../../../../common/constants");
var _navigation = require("./navigation");
var _utils = require("../../../common/components/visualization_actions/utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/hosts/pages/hosts_tabs.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const HostsTabs = exports.HostsTabs = /*#__PURE__*/_react.default.memo(({
  deleteQuery,
  filterQuery,
  from,
  indexNames,
  isInitializing,
  setQuery,
  to,
  type
}) => {
  const tabProps = {
    deleteQuery,
    endDate: to,
    filterQuery,
    indexNames,
    skip: isInitializing || filterQuery === undefined,
    setQuery,
    startDate: from,
    type
  };
  const hostNameExistsFilter = (0, _react.useMemo)(() => (0, _utils.fieldNameExistsFilter)(_constants.SecurityPageName.hosts), []);
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${_constants.HOSTS_PATH}/:tabName(${_model.HostsTableType.hosts})`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_navigation.HostsQueryTabBody, (0, _extends2.default)({}, tabProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${_constants.HOSTS_PATH}/:tabName(${_model.HostsTableType.risk})`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_navigation.HostRiskScoreQueryTabBody, (0, _extends2.default)({}, tabProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${_constants.HOSTS_PATH}/:tabName(${_model.HostsTableType.uncommonProcesses})`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_navigation.UncommonProcessQueryTabBody, (0, _extends2.default)({}, tabProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${_constants.HOSTS_PATH}/:tabName(${_model.HostsTableType.anomalies})`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_anomalies_query_tab_body.AnomaliesQueryTabBody, (0, _extends2.default)({}, tabProps, {
    AnomaliesTableComponent: _anomalies_host_table.AnomaliesHostTable,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${_constants.HOSTS_PATH}/:tabName(${_model.HostsTableType.events})`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_events_tab.EventsQueryTabBody, (0, _extends2.default)({
    additionalFilters: hostNameExistsFilter,
    tableId: _securitysolutionDataTable.TableId.hostsPageEvents
  }, tabProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${_constants.HOSTS_PATH}/:tabName(${_model.HostsTableType.sessions})`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_navigation.SessionsTabBody, (0, _extends2.default)({}, tabProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 11
    }
  }))));
});
HostsTabs.displayName = 'HostsTabs';