"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useHostDetails = exports.ID = void 0;
var _react = require("react");
var _hosts = require("../../../../../../common/search_strategy/security_solution/hosts");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_search_strategy = require("../../../../../common/containers/use_search_strategy");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ID = exports.ID = 'hostsDetailsQuery';
const useHostDetails = ({
  endDate,
  hostName,
  indexNames,
  id = ID,
  skip = false,
  startDate
}) => {
  const {
    loading,
    result: response,
    search,
    refetch,
    inspect
  } = (0, _use_search_strategy.useSearchStrategy)({
    factoryQueryType: _hosts.HostsQueries.details,
    initialResult: {
      hostDetails: {}
    },
    errorMessage: i18n.FAIL_HOST_OVERVIEW,
    abort: skip
  });
  const hostDetailsResponse = (0, _react.useMemo)(() => ({
    endDate,
    hostDetails: response.hostDetails,
    id,
    inspect,
    isInspected: false,
    refetch,
    startDate
  }), [endDate, response.hostDetails, id, inspect, refetch, startDate]);
  const hostDetailsRequest = (0, _react.useMemo)(() => ({
    defaultIndex: indexNames,
    factoryQueryType: _hosts.HostsQueries.details,
    hostName,
    timerange: {
      interval: '12h',
      from: startDate,
      to: endDate
    }
  }), [endDate, hostName, indexNames, startDate]);
  (0, _react.useEffect)(() => {
    if (!skip) {
      search(hostDetailsRequest);
    }
  }, [hostDetailsRequest, search, skip]);
  return [loading, hostDetailsResponse, refetch];
};
exports.useHostDetails = useHostDetails;