"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTrailingBreadcrumbs = void 0;
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isListDetailPage = pathname => pathname.includes(_constants.EXCEPTIONS_PATH) && pathname.includes('/details');

/**
 * This module should only export this function.
 * All the `getTrailingBreadcrumbs` functions in Security are loaded into the main bundle.
 * We should be careful to not import unnecessary modules in this file to avoid increasing the main app bundle size.
 */
const getTrailingBreadcrumbs = (params, getSecuritySolutionUrl) => {
  var _params$state;
  let breadcrumb = [];
  if (isListDetailPage(params.pathName) && (_params$state = params.state) !== null && _params$state !== void 0 && _params$state.listName) {
    breadcrumb = [...breadcrumb, {
      text: params.state.listName
    }];
  }
  return breadcrumb;
};
exports.getTrailingBreadcrumbs = getTrailingBreadcrumbs;