"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useExceptionsListCard = void 0;
var _react = require("react");
var _securitysolutionIoTsListTypes = require("@kbn/securitysolution-io-ts-list-types");
var _securitysolutionExceptionListComponents = require("@kbn/securitysolution-exception-list-components");
var _eui = require("@elastic/eui");
var _user_privileges = require("../../../common/components/user_privileges");
var _links = require("../../../common/components/links");
var _constants = require("../../../../common/constants");
var _use_list_exception_items = require("../use_list_exception_items");
var i18n = _interopRequireWildcard(require("../../translations"));
var _list = require("../../utils/list.utils");
var _expired_exceptions_list_items_modal = require("../../components/expired_exceptions_list_items_modal");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useExceptionsListCard = ({
  exceptionsList,
  handleExport,
  handleDelete,
  handleDuplicate,
  handleManageRules
}) => {
  const [viewerStatus, setViewerStatus] = (0, _react.useState)(_securitysolutionExceptionListComponents.ViewerStatus.LOADING);
  const [exceptionToEdit, setExceptionToEdit] = (0, _react.useState)();
  const [showAddExceptionFlyout, setShowAddExceptionFlyout] = (0, _react.useState)(false);
  const [showEditExceptionFlyout, setShowEditExceptionFlyout] = (0, _react.useState)(false);
  const [showIncludeExpiredExceptionsModal, setShowIncludeExpiredExceptionsModal] = (0, _react.useState)(null);
  const {
    read: canReadRules,
    edit: canEditRules
  } = (0, _user_privileges.useUserPrivileges)().rulesPrivileges;
  const {
    name: listName,
    list_id: listId,
    rules: listRules,
    type: listType,
    created_by: createdBy,
    created_at: createdAt,
    description: listDescription
  } = exceptionsList;
  const onFinishFetchingExceptions = (0, _react.useCallback)(() => {
    setViewerStatus('');
  }, [setViewerStatus]);
  const onEditExceptionItem = exception => {
    setExceptionToEdit(exception);
    setShowEditExceptionFlyout(true);
  };
  const {
    lastUpdated,
    exceptionViewerStatus,
    exceptions,
    pagination,
    ruleReferences,
    fetchItems,
    onDeleteException,
    onPaginationChange
  } = (0, _use_list_exception_items.useListExceptionItems)({
    list: exceptionsList,
    deleteToastTitle: i18n.EXCEPTION_ITEM_DELETE_TITLE,
    deleteToastBody: name => i18n.EXCEPTION_ITEM_DELETE_TEXT(name),
    errorToastBody: i18n.EXCEPTION_ERROR_DESCRIPTION,
    errorToastTitle: i18n.EXCEPTION_ERROR_TITLE,
    onEditListExceptionItem: onEditExceptionItem,
    onFinishFetchingExceptions
  });
  (0, _react.useEffect)(() => {
    fetchItems(null, _securitysolutionExceptionListComponents.ViewerStatus.LOADING);
  }, [fetchItems]);
  const [toggleAccordion, setToggleAccordion] = (0, _react.useState)(false);
  const openAccordionId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'openAccordion'
  });
  const listCannotBeEdited = (0, _list.checkIfListCannotBeEdited)(exceptionsList) || !canEditRules;
  const emptyViewerTitle = (0, _react.useMemo)(() => {
    return viewerStatus === _securitysolutionExceptionListComponents.ViewerStatus.EMPTY ? i18n.EXCEPTION_LIST_EMPTY_VIEWER_TITLE : '';
  }, [viewerStatus]);
  const emptyViewerBody = (0, _react.useMemo)(() => {
    return viewerStatus === _securitysolutionExceptionListComponents.ViewerStatus.EMPTY ? i18n.EXCEPTION_LIST_EMPTY_VIEWER_BODY(exceptionsList.name) : '';
  }, [exceptionsList.name, viewerStatus]);
  const emptyViewerButtonText = (0, _react.useMemo)(() => {
    return exceptionsList.type === _securitysolutionIoTsListTypes.ExceptionListTypeEnum.ENDPOINT ? i18n.EXCEPTION_LIST_EMPTY_VIEWER_BUTTON_ENDPOINT : i18n.EXCEPTION_LIST_EMPTY_VIEWER_BUTTON;
  }, [exceptionsList.type]);
  const menuActionItems = (0, _react.useMemo)(() => [{
    key: 'Export',
    icon: 'exportAction',
    label: i18n.EXPORT_EXCEPTION_LIST,
    onClick: e => {
      if (listType === _securitysolutionIoTsListTypes.ExceptionListTypeEnum.ENDPOINT) {
        handleExport({
          id: exceptionsList.id,
          listId: exceptionsList.list_id,
          name: exceptionsList.name,
          namespaceType: exceptionsList.namespace_type,
          includeExpiredExceptions: true
        })();
      } else {
        setShowIncludeExpiredExceptionsModal(_expired_exceptions_list_items_modal.CHECK_EXCEPTION_TTL_ACTION_TYPES.EXPORT);
      }
    },
    disabled: listType === _securitysolutionIoTsListTypes.ExceptionListTypeEnum.ENDPOINT ? false : !canReadRules
  }, {
    key: 'Duplicate',
    icon: 'copy',
    label: i18n.DUPLICATE_EXCEPTION_LIST,
    disabled: listCannotBeEdited,
    onClick: _ => {
      setShowIncludeExpiredExceptionsModal(_expired_exceptions_list_items_modal.CHECK_EXCEPTION_TTL_ACTION_TYPES.DUPLICATE);
    }
  }, {
    key: 'Delete',
    icon: 'trash',
    disabled: listCannotBeEdited,
    label: i18n.DELETE_EXCEPTION_LIST,
    onClick: e => {
      handleDelete({
        id: exceptionsList.id,
        listId: exceptionsList.list_id,
        namespaceType: exceptionsList.namespace_type
      })();
    }
  }, {
    key: 'LinkRules',
    icon: 'gear',
    disabled: listCannotBeEdited,
    label: i18n.LINK_RULES_OVERFLOW_BUTTON_TITLE,
    onClick: e => {
      handleManageRules();
    }
  }], [listType, canReadRules, listCannotBeEdited, handleExport, exceptionsList.id, exceptionsList.list_id, exceptionsList.name, exceptionsList.namespace_type, handleDelete, handleManageRules]);

  // Once details Page is added all of these methods will be used from it as well
  // as their own states
  const onAddExceptionClick = (0, _react.useCallback)(() => {
    setShowAddExceptionFlyout(true);
  }, [setShowAddExceptionFlyout]);
  const handleCancelExceptionItemFlyout = () => {
    setShowAddExceptionFlyout(false);
    setShowEditExceptionFlyout(false);
  };
  const handleConfirmExceptionFlyout = (0, _react.useCallback)(didExceptionChange => {
    setShowAddExceptionFlyout(false);
    setShowEditExceptionFlyout(false);
    if (!didExceptionChange) return;
    fetchItems();
  }, [fetchItems, setShowAddExceptionFlyout, setShowEditExceptionFlyout]);
  const onExportListClick = (0, _react.useCallback)(() => {
    setShowIncludeExpiredExceptionsModal(_expired_exceptions_list_items_modal.CHECK_EXCEPTION_TTL_ACTION_TYPES.EXPORT);
  }, [setShowIncludeExpiredExceptionsModal]);
  const handleCancelExpiredExceptionsModal = () => {
    setShowIncludeExpiredExceptionsModal(null);
  };
  const handleConfirmExpiredExceptionsModal = (0, _react.useCallback)(includeExpiredExceptions => {
    if (showIncludeExpiredExceptionsModal === _expired_exceptions_list_items_modal.CHECK_EXCEPTION_TTL_ACTION_TYPES.EXPORT) {
      handleExport({
        id: exceptionsList.id,
        listId: exceptionsList.list_id,
        name: exceptionsList.name,
        namespaceType: exceptionsList.namespace_type,
        includeExpiredExceptions
      })();
    }
    if (showIncludeExpiredExceptionsModal === _expired_exceptions_list_items_modal.CHECK_EXCEPTION_TTL_ACTION_TYPES.DUPLICATE) {
      handleDuplicate({
        listId: exceptionsList.list_id,
        name: exceptionsList.name,
        namespaceType: exceptionsList.namespace_type,
        includeExpiredExceptions
      })();
    }
  }, [showIncludeExpiredExceptionsModal, handleExport, exceptionsList.id, exceptionsList.list_id, exceptionsList.name, exceptionsList.namespace_type, handleDuplicate]);

  // routes to x-pack/solutions/security/plugins/security_solution/public/exceptions/routes.tsx
  // details component is here: x-pack/solutions/security/plugins/security_solution/public/exceptions/pages/list_detail_view/index.tsx
  const {
    onClick: goToExceptionDetail
  } = (0, _links.useGetSecuritySolutionLinkProps)()({
    deepLinkId: _constants.SecurityPageName.exceptions,
    path: `/details/${exceptionsList.list_id}`
  });
  return {
    listId,
    listName,
    listDescription,
    createdAt: new Date(createdAt).toDateString(),
    createdBy,
    listRulesCount: listRules.length.toString(),
    exceptionItemsCount: pagination.totalItemCount.toString(),
    listType,
    menuActionItems,
    showAddExceptionFlyout,
    toggleAccordion,
    openAccordionId,
    viewerStatus,
    exceptionToEdit,
    showEditExceptionFlyout,
    lastUpdated,
    exceptions,
    ruleReferences,
    pagination,
    exceptionViewerStatus,
    onEditExceptionItem,
    onDeleteException,
    onPaginationChange,
    setToggleAccordion,
    onAddExceptionClick,
    handleConfirmExceptionFlyout,
    handleCancelExceptionItemFlyout,
    goToExceptionDetail,
    emptyViewerTitle,
    emptyViewerBody,
    emptyViewerButtonText,
    showIncludeExpiredExceptionsModal,
    onExportListClick,
    handleCancelExpiredExceptionsModal,
    handleConfirmExpiredExceptionsModal
  };
};
exports.useExceptionsListCard = useExceptionsListCard;