"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntityAnalyticsPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _translations = require("../../app/translations");
var _spy_routes = require("../../common/utils/route/spy_routes");
var _types = require("../../app/types");
var _containers = require("../../sourcerer/containers");
var _page_wrapper = require("../../common/components/page_wrapper");
var _header_page = require("../../common/components/header_page");
var _empty_prompt = require("../../common/components/empty_prompt");
var _search_bar = require("../../common/components/search_bar");
var _constants = require("../../common/store/inputs/constants");
var _filters_global = require("../../common/components/filters_global");
var _entity_analytics_header = require("../components/entity_analytics_header");
var _entity_analytics_anomalies = require("../components/entity_analytics_anomalies");
var _dashboard_entity_store_panels = require("../components/entity_store/components/dashboard_entity_store_panels");
var _entity_analytics_risk_score = require("../components/entity_analytics_risk_score");
var _use_experimental_features = require("../../common/hooks/use_experimental_features");
var _use_data_view = require("../../data_view_manager/hooks/use_data_view");
var _use_enabled_entity_types = require("../hooks/use_enabled_entity_types");
var _page_loader = require("../../common/components/page_loader");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/pages/entity_analytics_dashboard.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EntityAnalyticsComponent = () => {
  var _dataView$matchedIndi2;
  const [skipEmptyPrompt, setSkipEmptyPrompt] = _react.default.useState(false);
  const onSkip = _react.default.useCallback(() => setSkipEmptyPrompt(true), [setSkipEmptyPrompt]);
  const {
    indicesExist: oldIndicesExist,
    loading: oldIsSourcererLoading,
    sourcererDataView: oldSourcererDataViewSpec
  } = (0, _containers.useSourcererDataView)();
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const {
    dataView,
    status
  } = (0, _use_data_view.useDataView)();
  const indicesExist = (0, _react.useMemo)(() => {
    var _dataView$matchedIndi;
    return newDataViewPickerEnabled ? !!(dataView !== null && dataView !== void 0 && (_dataView$matchedIndi = dataView.matchedIndices) !== null && _dataView$matchedIndi !== void 0 && _dataView$matchedIndi.length) : oldIndicesExist;
  }, [dataView === null || dataView === void 0 ? void 0 : (_dataView$matchedIndi2 = dataView.matchedIndices) === null || _dataView$matchedIndi2 === void 0 ? void 0 : _dataView$matchedIndi2.length, newDataViewPickerEnabled, oldIndicesExist]);
  const isSourcererLoading = (0, _react.useMemo)(() => newDataViewPickerEnabled ? status !== 'ready' : oldIsSourcererLoading, [newDataViewPickerEnabled, oldIsSourcererLoading, status]);
  const isEntityStoreFeatureFlagDisabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('entityStoreDisabled');
  const showEmptyPrompt = !indicesExist && !skipEmptyPrompt;
  const entityTypes = (0, _use_enabled_entity_types.useEntityAnalyticsTypes)();
  if (newDataViewPickerEnabled && status === 'pristine') {
    return /*#__PURE__*/_react.default.createElement(_page_loader.PageLoader, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showEmptyPrompt ? /*#__PURE__*/_react.default.createElement(_empty_prompt.EmptyPrompt, {
    onSkip: onSkip,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_filters_global.FiltersGlobal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_search_bar.SiemSearchBar, {
    dataView: dataView,
    id: _constants.InputsModelId.global,
    sourcererDataViewSpec: oldSourcererDataViewSpec // TODO remove when we remove the newDataViewPickerEnabled feature flag
    ,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, {
    "data-test-subj": "entityAnalyticsPage",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
    title: _translations.ENTITY_ANALYTICS,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 13
    }
  }), isSourcererLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "l",
    "data-test-subj": "entityAnalyticsLoader",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 15
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    "data-test-subj": "entityAnalyticsSections",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_entity_analytics_header.EntityAnalyticsHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 19
    }
  })), !isEntityStoreFeatureFlagDisabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_dashboard_entity_store_panels.EntityStoreDashboardPanels, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 21
    }
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, entityTypes.map(entityType => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: entityType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_entity_analytics_risk_score.EntityAnalyticsRiskScores, {
    riskEntity: entityType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 25
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_entity_analytics_anomalies.EntityAnalyticsAnomalies, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 19
    }
  }))))), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _types.SecurityPageName.entityAnalytics,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 7
    }
  }));
};
const EntityAnalyticsPage = exports.EntityAnalyticsPage = EntityAnalyticsComponent;