"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThreatHuntingEntitiesTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _fp = require("lodash/fp");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _use_error_toast = require("../../../common/hooks/use_error_toast");
var _manage_query = require("../../../common/components/page/manage_query");
var _common = require("../../../../common/search_strategy/common");
var _use_global_time = require("../../../common/containers/use_global_time");
var _query_toggle = require("../../../common/containers/query_toggle");
var _paginated_table = require("../../../explore/components/paginated_table");
var _types = require("../../../../common/entity_analytics/types");
var _search_strategy = require("../../../../common/search_strategy");
var _risk_engine = require("../../../../common/entity_analytics/risk_engine");
var _use_investigate_in_timeline = require("../../../common/hooks/timeline/use_investigate_in_timeline");
var _user_privileges = require("../../../common/components/user_privileges");
var _data_provider = require("../../../app/actions/add_to_timeline/data_provider");
var _utils = require("../../common/utils");
var _empty_value = require("../../../common/components/empty_value");
var _use_entities_list_query = require("../entity_store/hooks/use_entities_list_query");
var _use_entities_list_filters = require("../entity_store/hooks/use_entities_list_filters");
var _use_enabled_entity_types = require("../../hooks/use_enabled_entity_types");
var _helpers = require("../entity_store/helpers");
var _translations = require("../asset_criticality/translations");
var _formatted_date = require("../../../common/components/formatted_date");
var _common2 = require("../severity/common");
var _constants = require("../../../flyout/entity_details/shared/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/threat_hunting/threat_hunting_entities_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const THREAT_HUNTING_TABLE_ID = 'threat-hunting-table';

/**
 * Creates data providers for timeline investigation based on entity type and name
 */
const createEntityDataProviders = (entityType, entityName) => {
  if (!entityName || !entityType) {
    return null;
  }

  // Map entity type to the appropriate field name, fallback to 'entity.id' if not found
  const fieldName = _types.EntityTypeToIdentifierField[entityType] || 'entity.id';
  const dataProviders = (0, _data_provider.createDataProviders)({
    contextId: THREAT_HUNTING_TABLE_ID,
    field: fieldName,
    values: entityName
  });
  return dataProviders;
};

/**
 * Helper function to get risk score colors based on risk level
 */
const getRiskScoreColors = (level, euiTheme) => {
  switch (level) {
    case _search_strategy.RiskSeverity.Unknown:
      return {
        background: euiTheme.colors.backgroundBaseSubdued,
        text: euiTheme.colors.textSubdued
      };
    case _search_strategy.RiskSeverity.Low:
      return {
        background: euiTheme.colors.backgroundBaseNeutral,
        text: euiTheme.colors.textNeutral
      };
    case _search_strategy.RiskSeverity.Moderate:
      return {
        background: euiTheme.colors.backgroundLightWarning,
        text: euiTheme.colors.textWarning
      };
    case _search_strategy.RiskSeverity.High:
      return {
        background: euiTheme.colors.backgroundLightRisk,
        text: euiTheme.colors.textRisk
      };
    case _search_strategy.RiskSeverity.Critical:
      return {
        background: euiTheme.colors.backgroundLightDanger,
        text: euiTheme.colors.textDanger
      };
  }
};
const useThreatHuntingColumns = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    investigateInTimeline
  } = (0, _use_investigate_in_timeline.useInvestigateInTimeline)();
  const {
    timelinePrivileges: {
      read: canUseTimeline
    }
  } = (0, _user_privileges.useUserPrivileges)();
  const {
    openRightPanel
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  return [{
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.threatHunting.actionsColumn.title",
      defaultMessage: "Actions",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 141,
        columnNumber: 9
      }
    }),
    render: record => {
      const entityType = (0, _helpers.getEntityType)(record);
      const entityName = record.entity.name;
      const handleFlyoutClick = () => {
        const id = _constants.EntityPanelKeyByType[entityType];
        if (id && entityName) {
          var _EntityPanelParamByTy;
          openRightPanel({
            id,
            params: {
              [(_EntityPanelParamByTy = _constants.EntityPanelParamByType[entityType]) !== null && _EntityPanelParamByTy !== void 0 ? _EntityPanelParamByTy : '']: entityName,
              contextID: THREAT_HUNTING_TABLE_ID,
              scopeId: THREAT_HUNTING_TABLE_ID
            }
          });
        }
      };
      const handleTimelineClick = () => {
        const dataProviders = createEntityDataProviders(entityType, entityName);
        if (dataProviders && dataProviders.length > 0) {
          investigateInTimeline({
            dataProviders
          });
        }
      };
      if (!entityName) {
        return null;
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "xs",
        alignItems: "center",
        responsive: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 179,
          columnNumber: 11
        }
      }, _constants.EntityPanelKeyByType[entityType] && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 181,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.threatHunting.entityPreview.tooltip', {
          defaultMessage: 'Preview entity'
        }),
        disableScreenReaderOutput: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 182,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        iconType: "expand",
        onClick: handleFlyoutClick,
        "aria-label": _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.threatHunting.entityPreview.ariaLabel', {
          defaultMessage: 'Preview entity with name {name}',
          values: {
            name: entityName
          }
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 191,
          columnNumber: 19
        }
      }))), canUseTimeline && entityName && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 206,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.threatHunting.investigateInTimeline', {
          defaultMessage: 'Investigate in timeline'
        }),
        disableScreenReaderOutput: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 207,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        iconType: "timeline",
        size: "s",
        color: "text",
        onClick: handleTimelineClick,
        "aria-label": _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.threatHunting.investigateInTimeline', {
          defaultMessage: 'Investigate in timeline'
        }),
        "data-test-subj": "threat-hunting-timeline-icon",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 216,
          columnNumber: 19
        }
      }))));
    },
    width: '5%'
  }, {
    field: 'entity.name',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.threatHunting.nameColumn.title",
      defaultMessage: "Name",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 240,
        columnNumber: 9
      }
    }),
    sortable: true,
    truncateText: {
      lines: 2
    },
    render: (_, record) => {
      const entityType = (0, _helpers.getEntityType)(record);
      const entityName = record.entity.name;
      return /*#__PURE__*/_react.default.createElement("span", {
        style: {
          overflow: 'hidden',
          textOverflow: 'ellipsis',
          whiteSpace: 'nowrap'
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 252,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: _helpers.EntityIconByType[entityType],
        "aria-label": `${entityType} entity`,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 253,
          columnNumber: 13
        }
      }), /*#__PURE__*/_react.default.createElement("span", {
        css: {
          paddingLeft: euiTheme.size.s
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 254,
          columnNumber: 13
        }
      }, entityName));
    },
    width: '25%'
  }, {
    field: 'entity.source',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.threatHunting.sourceColumn.title",
      defaultMessage: "Source",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 263,
        columnNumber: 9
      }
    }),
    width: '25%',
    truncateText: {
      lines: 2
    },
    render: source => {
      if (source != null) {
        return (0, _helpers.sourceFieldToText)(source);
      }
      return (0, _empty_value.getEmptyTagValue)();
    }
  }, {
    field: 'asset.criticality',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.threatHunting.criticalityColumn.title",
      defaultMessage: "Criticality",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 280,
        columnNumber: 9
      }
    }),
    width: '10%',
    render: criticality => {
      if (criticality != null) {
        return /*#__PURE__*/_react.default.createElement("span", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 288,
            columnNumber: 18
          }
        }, _translations.CRITICALITY_LEVEL_TITLE[criticality]);
      }
      return (0, _empty_value.getEmptyTagValue)();
    }
  }, {
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.threatHunting.riskScoreColumn.title",
      defaultMessage: "Risk score",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 295,
        columnNumber: 9
      }
    }),
    width: '10%',
    render: entity => {
      const entityType = (0, _helpers.getEntityType)(entity);

      // Get risk score using EntityTypeToScoreField
      const riskScore = (0, _fp.get)(_search_strategy.EntityTypeToScoreField[entityType], entity);

      // Get risk level using EntityTypeToLevelField
      const riskLevel = (0, _fp.get)(_search_strategy.EntityTypeToLevelField[entityType], entity);

      // If we have neither risk score nor risk level, show empty
      if ((riskScore === undefined || riskScore === null) && !riskLevel) {
        return (0, _empty_value.getEmptyTagValue)();
      }

      // Determine risk level from risk score if not directly available
      const level = riskLevel || (riskScore != null ? (0, _risk_engine.getRiskLevel)(riskScore) : _search_strategy.RiskSeverity.Unknown);
      const colors = getRiskScoreColors(level, euiTheme);
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: colors.background,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 324,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        css: (0, _react2.css)`
                font-weight: ${euiTheme.font.weight.semiBold};
              `,
        size: 's',
        color: colors.text,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 325,
          columnNumber: 13
        }
      }, riskScore !== undefined && riskScore !== null ? (0, _utils.formatRiskScoreWholeNumber)(riskScore) : _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.threatHunting.riskScore.na', {
        defaultMessage: 'N/A'
      })));
    }
  }, {
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.threatHunting.riskLevelColumn.title",
      defaultMessage: "Risk Level",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 347,
        columnNumber: 9
      }
    }),
    width: '10%',
    render: entity => {
      const entityType = (0, _helpers.getEntityType)(entity);
      const riskLevel = (0, _fp.get)(_search_strategy.EntityTypeToLevelField[entityType], entity);
      if (riskLevel != null) {
        return /*#__PURE__*/_react.default.createElement(_common2.RiskScoreLevel, {
          severity: riskLevel,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 360,
            columnNumber: 18
          }
        });
      }
      return (0, _empty_value.getEmptyTagValue)();
    }
  }, {
    field: '@timestamp',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.threatHunting.lastUpdateColumn.title",
      defaultMessage: "Last Update",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 368,
        columnNumber: 9
      }
    }),
    sortable: true,
    render: lastUpdate => {
      return /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
        value: lastUpdate,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 375,
          columnNumber: 16
        }
      });
    },
    width: '15%'
  }];
};
const ThreatHuntingEntitiesTable = () => {
  var _data$inspect, _data$total, _data$records, _data$total2;
  const {
    deleteQuery,
    setQuery,
    isInitializing
  } = (0, _use_global_time.useGlobalTime)();
  const [activePage, setActivePage] = (0, _react.useState)(0);
  const [limit, setLimit] = (0, _react.useState)(10);
  const {
    toggleStatus
  } = (0, _query_toggle.useQueryToggle)(THREAT_HUNTING_TABLE_ID);
  const [sorting, setSorting] = (0, _react.useState)({
    field: '@timestamp',
    direction: _common.Direction.desc
  });
  const entityTypes = (0, _use_enabled_entity_types.useEntityStoreTypes)();
  const [selectedSeverities, _setSelectedSeverities] = (0, _react.useState)([]);
  const [selectedCriticalities, _setSelectedCriticalities] = (0, _react.useState)([]);
  const [selectedSources, _setSelectedSources] = (0, _react.useState)([]);
  const filter = (0, _use_entities_list_filters.useEntitiesListFilters)({
    selectedSeverities,
    selectedCriticalities,
    selectedSources
  });
  const [querySkip, setQuerySkip] = (0, _react.useState)(isInitializing || !toggleStatus);
  (0, _react.useEffect)(() => {
    setQuerySkip(isInitializing || !toggleStatus);
  }, [isInitializing, toggleStatus]);
  const onSort = (0, _react.useCallback)(criteria => {
    if (criteria.sort != null) {
      const newSort = criteria.sort;
      if (newSort.direction !== sorting.direction || newSort.field !== sorting.field) {
        setSorting(newSort);
      }
    }
  }, [sorting]);
  const searchParams = (0, _react.useMemo)(() => ({
    entityTypes,
    page: activePage + 1,
    perPage: limit,
    sortField: sorting.field,
    sortOrder: sorting.direction,
    skip: querySkip,
    filterQuery: JSON.stringify({
      bool: {
        filter
      }
    })
  }), [entityTypes, activePage, limit, sorting.field, sorting.direction, querySkip, filter]);
  const {
    data,
    isLoading,
    isRefetching,
    refetch,
    error
  } = (0, _use_entities_list_query.useEntitiesListQuery)(searchParams);
  (0, _manage_query.useQueryInspector)({
    queryId: THREAT_HUNTING_TABLE_ID,
    loading: isLoading || isRefetching,
    refetch,
    setQuery,
    deleteQuery,
    inspect: (_data$inspect = data === null || data === void 0 ? void 0 : data.inspect) !== null && _data$inspect !== void 0 ? _data$inspect : null
  });

  // Reset the active page when the search criteria changes
  (0, _react.useEffect)(() => {
    setActivePage(0);
  }, [sorting, limit, filter]);
  const columns = useThreatHuntingColumns();
  (0, _use_error_toast.useErrorToast)(_i18n.i18n.translate('xpack.securitySolution.entityAnalytics.threatHunting.queryError', {
    defaultMessage: 'There was an error loading the entities list'
  }), error);
  return /*#__PURE__*/_react.default.createElement(_paginated_table.PaginatedTable, {
    id: THREAT_HUNTING_TABLE_ID,
    dataTestSubj: "threat-hunting-entities-table",
    activePage: activePage,
    columns: columns,
    headerCount: (_data$total = data === null || data === void 0 ? void 0 : data.total) !== null && _data$total !== void 0 ? _data$total : 0,
    titleSize: "s",
    headerTitle: _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.threatHunting.tableTitle', {
      defaultMessage: 'Entities'
    }),
    headerTooltip: _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.threatHunting.tableTooltip', {
      defaultMessage: 'Entity data can take a couple of minutes to appear'
    }),
    limit: limit,
    loading: isLoading || isRefetching,
    isInspect: false,
    updateActivePage: setActivePage,
    loadPage: _fp.noop,
    pageOfItems: (_data$records = data === null || data === void 0 ? void 0 : data.records) !== null && _data$records !== void 0 ? _data$records : [],
    setQuerySkip: setQuerySkip,
    showMorePagesIndicator: false,
    updateLimitPagination: setLimit,
    totalCount: (_data$total2 = data === null || data === void 0 ? void 0 : data.total) !== null && _data$total2 !== void 0 ? _data$total2 : 0,
    itemsPerRow: [{
      text: _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.threatHunting.rows', {
        values: {
          numRows: 10
        },
        defaultMessage: '{numRows} {numRows, plural, =0 {rows} =1 {row} other {rows}}'
      }),
      numberOfRow: 10
    }, {
      text: _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.threatHunting.rows', {
        values: {
          numRows: 25
        },
        defaultMessage: '{numRows} {numRows, plural, =0 {rows} =1 {row} other {rows}}'
      }),
      numberOfRow: 25
    }],
    sorting: sorting,
    onChange: onSort,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 461,
      columnNumber: 5
    }
  });
};
exports.ThreatHuntingEntitiesTable = ThreatHuntingEntitiesTable;