"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskLevelBreakdownTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _search_strategy = require("../../../../common/search_strategy");
var _common = require("../severity/common");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/threat_hunting/risk_level_breakdown_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RiskLevelBreakdownTable = ({
  severityCount,
  loading = false
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const tableItems = (0, _react.useMemo)(() => {
    var _severityCount$RiskSe, _severityCount$RiskSe2, _severityCount$RiskSe3, _severityCount$RiskSe4, _severityCount$RiskSe5;
    return [{
      level: _search_strategy.RiskSeverity.Critical,
      scoreRange: '>90',
      count: (_severityCount$RiskSe = severityCount[_search_strategy.RiskSeverity.Critical]) !== null && _severityCount$RiskSe !== void 0 ? _severityCount$RiskSe : 0
    }, {
      level: _search_strategy.RiskSeverity.High,
      scoreRange: '70-90',
      count: (_severityCount$RiskSe2 = severityCount[_search_strategy.RiskSeverity.High]) !== null && _severityCount$RiskSe2 !== void 0 ? _severityCount$RiskSe2 : 0
    }, {
      level: _search_strategy.RiskSeverity.Moderate,
      scoreRange: '40-70',
      count: (_severityCount$RiskSe3 = severityCount[_search_strategy.RiskSeverity.Moderate]) !== null && _severityCount$RiskSe3 !== void 0 ? _severityCount$RiskSe3 : 0
    }, {
      level: _search_strategy.RiskSeverity.Low,
      scoreRange: '20-40',
      count: (_severityCount$RiskSe4 = severityCount[_search_strategy.RiskSeverity.Low]) !== null && _severityCount$RiskSe4 !== void 0 ? _severityCount$RiskSe4 : 0
    }, {
      level: _search_strategy.RiskSeverity.Unknown,
      scoreRange: '<20',
      count: (_severityCount$RiskSe5 = severityCount[_search_strategy.RiskSeverity.Unknown]) !== null && _severityCount$RiskSe5 !== void 0 ? _severityCount$RiskSe5 : 0
    }];
  }, [severityCount]);
  const columns = (0, _react.useMemo)(() => [{
    field: 'level',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.threatHunting.riskLevelBreakdown.riskLevel",
      defaultMessage: "Risk level",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 11
      }
    }),
    render: level => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_common.RiskScoreLevel, {
      hideBackgroundColor: true,
      severity: level,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 13
      }
    }))
  }, {
    field: 'scoreRange',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.threatHunting.riskLevelBreakdown.riskScore",
      defaultMessage: "Risk score",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 11
      }
    }),
    render: scoreRange => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      style: {
        fontWeight: euiTheme.font.weight.medium
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 11
      }
    }, scoreRange)
  }, {
    field: 'count',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.threatHunting.riskLevelBreakdown.numberOfEntities",
      defaultMessage: "Number of entities",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 11
      }
    }),
    dataType: 'number',
    render: count => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      style: {
        fontWeight: euiTheme.font.weight.semiBold
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 11
      }
    }, count.toLocaleString())
  }], [euiTheme]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: tableItems,
    columns: columns,
    loading: loading,
    tableCaption: "Risk level breakdown by entity count",
    "data-test-subj": "risk-level-breakdown-table",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 5
    }
  });
};
exports.RiskLevelBreakdownTable = RiskLevelBreakdownTable;