"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskScoreLevel = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _react2 = require("@emotion/react");
var _utils = require("../../../common/utils");
var _hover_popover = require("../../../../common/components/hover_popover");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/severity/common/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const RiskBadge = (0, _styled.default)('div', {
  shouldForwardProp: prop => !['severity', 'hideBackgroundColor'].includes(prop)
})`
  ${({
  theme: {
    euiTheme
  },
  color,
  severity,
  hideBackgroundColor
}) => (0, _react2.css)`
    width: fit-content;
    padding-right: ${euiTheme.size.s};
    padding-left: ${euiTheme.size.xs};

    ${(severity === 'Critical' || severity === 'High') && !hideBackgroundColor && (0, _react2.css)`
      background-color: ${color};
      border-radius: 999px; // pill shaped
    `};
  `}
`;
const TooltipContainer = _styled.default.div`
  padding: ${({
  theme: {
    euiTheme
  }
}) => euiTheme.size.s};
`;
const RiskScoreLevel = exports.RiskScoreLevel = /*#__PURE__*/_react.default.memo(({
  severity,
  hideBackgroundColor = false,
  toolTipContent,
  'data-test-subj': dataTestSubj
}) => {
  if (toolTipContent != null) {
    return /*#__PURE__*/_react.default.createElement(_hover_popover.HoverPopover, {
      hoverContent: /*#__PURE__*/_react.default.createElement(TooltipContainer, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 50,
          columnNumber: 37
        }
      }, toolTipContent),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(RiskScoreBadge, {
      severity: severity,
      hideBackgroundColor: hideBackgroundColor,
      "data-test-subj": dataTestSubj,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 11
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(RiskScoreBadge, {
    severity: severity,
    hideBackgroundColor: hideBackgroundColor,
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  });
});
RiskScoreLevel.displayName = 'RiskScoreLevel';
const RiskScoreBadge = /*#__PURE__*/_react.default.memo(({
  severity,
  hideBackgroundColor = false,
  'data-test-subj': dataTestSubj
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(RiskBadge, {
    color: euiTheme.colors.backgroundBaseDanger,
    severity: severity,
    hideBackgroundColor: hideBackgroundColor,
    "data-test-subj": dataTestSubj !== null && dataTestSubj !== void 0 ? dataTestSubj : 'risk-score',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "default",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    className: "eui-alignMiddle",
    color: _utils.RISK_SEVERITY_COLOUR[severity],
    textSize: "inherit",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 9
    }
  }, severity)));
});
RiskScoreBadge.displayName = 'RiskScoreBadge';