"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskScorePreviewSection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../data_view_manager/constants");
var _types = require("../../../../common/entity_analytics/types");
var _risk_engine = require("../../../../common/entity_analytics/risk_engine");
var _risk_score_preview_table = require("./risk_score_preview_table");
var i18n = _interopRequireWildcard(require("../../translations"));
var _use_preview_risk_scores = require("../../api/hooks/use_preview_risk_scores");
var _containers = require("../../../sourcerer/containers");
var _common = require("../../common");
var _helpers = require("../entity_store/helpers");
var _use_experimental_features = require("../../../common/hooks/use_experimental_features");
var _use_data_view = require("../../../data_view_manager/hooks/use_data_view");
var _use_enabled_entity_types = require("../../hooks/use_enabled_entity_types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/risk_score_management/risk_score_preview_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getRiskiestScores = (scores = [], field) => {
  var _scores$filter, _scores$filter$sort;
  return (scores === null || scores === void 0 ? void 0 : (_scores$filter = scores.filter(item => (item === null || item === void 0 ? void 0 : item.id_field) === field)) === null || _scores$filter === void 0 ? void 0 : (_scores$filter$sort = _scores$filter.sort((a, b) => (b === null || b === void 0 ? void 0 : b.calculated_score_norm) - (a === null || a === void 0 ? void 0 : a.calculated_score_norm))) === null || _scores$filter$sort === void 0 ? void 0 : _scores$filter$sort.slice(0, 5)) || [];
};
const RiskScorePreviewSection = ({
  privileges,
  includeClosedAlerts,
  from,
  to,
  alertFilters
}) => {
  const sectionBody = (0, _react.useMemo)(() => {
    if (privileges.isLoading) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        justifyContent: "center",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 66,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 67,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "xl",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 68,
          columnNumber: 13
        }
      })));
    }
    if ((0, _common.userHasRiskEngineReadPermissions)(privileges)) {
      return /*#__PURE__*/_react.default.createElement(RiskEnginePreview, {
        includeClosedAlerts: includeClosedAlerts,
        from: from,
        to: to,
        alertFilters: alertFilters,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 75,
          columnNumber: 9
        }
      });
    }
    return /*#__PURE__*/_react.default.createElement(MissingPermissionsCallout, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 12
      }
    });
  }, [privileges, includeClosedAlerts, from, to, alertFilters]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 9
    }
  }, i18n.PREVIEW)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 's',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  }), sectionBody);
};
exports.RiskScorePreviewSection = RiskScorePreviewSection;
const MissingPermissionsCallout = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: i18n.PREVIEW_MISSING_PERMISSIONS_TITLE,
    color: "primary",
    iconType: "info",
    "data-test-subj": "missing-risk-engine-preview-permissions",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.riskScore.riskScorePreview.missingPermissionsCallout.description",
    defaultMessage: "Read permission is required for the {index} index pattern in order to preview data. Contact your administrator for further assistance.",
    values: {
      index: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 111,
          columnNumber: 20
        }
      }, _risk_engine.RISK_SCORE_INDEX_PATTERN)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 9
    }
  })));
};
const RiskScorePreviewPanel = ({
  items,
  showMessage,
  hideMessage,
  isLoading,
  type
}) => {
  const [trigger, setTrigger] = (0, _react.useState)('open');
  const onToggle = isOpen => {
    const newState = isOpen ? 'open' : 'closed';
    setTrigger(newState);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    initialIsOpen: true,
    isLoading: isLoading,
    id: 'host-table',
    buttonContent: trigger === 'closed' ? showMessage : hideMessage,
    forceState: trigger,
    onToggle: onToggle,
    extraAction: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: _helpers.EntityIconByType[type],
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 141,
        columnNumber: 22
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_risk_score_preview_table.RiskScorePreviewTable, {
    items: items,
    type: type,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 11
    }
  }))));
};
const RiskEnginePreview = ({
  includeClosedAlerts,
  from,
  to,
  alertFilters
}) => {
  const entityTypes = (0, _use_enabled_entity_types.useEntityAnalyticsTypes)();
  const [filters] = (0, _react.useState)({
    bool: {
      must: [],
      filter: [],
      should: [],
      must_not: []
    }
  });
  const {
    sourcererDataView: oldSourcererDataView
  } = (0, _containers.useSourcererDataView)(_constants.PageScope.alerts);
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const {
    dataView: experimentalDataView
  } = (0, _use_data_view.useDataView)(_constants.PageScope.alerts);
  const sourcererDataView = newDataViewPickerEnabled ? experimentalDataView : oldSourcererDataView;
  const {
    data,
    isLoading,
    refetch,
    isError
  } = (0, _use_preview_risk_scores.useRiskScorePreview)({
    data_view_id: sourcererDataView === null || sourcererDataView === void 0 ? void 0 : sourcererDataView.title,
    filter: filters,
    range: {
      start: from,
      end: to
    },
    exclude_alert_statuses: includeClosedAlerts ? [] : ['closed'],
    // Pass filters to API (will only work once backend PR merges)
    filters: alertFilters && alertFilters.length > 0 ? alertFilters : undefined
  });
  if (isError) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      announceOnMount: true,
      "data-test-subj": "risk-preview-error",
      title: i18n.PREVIEW_ERROR_TITLE,
      color: "danger",
      iconType: "error",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 185,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 192,
        columnNumber: 9
      }
    }, i18n.PREVIEW_ERROR_MESSAGE), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "risk-preview-error-button",
      color: "danger",
      onClick: () => refetch(),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 193,
        columnNumber: 9
      }
    }, i18n.PREVIEW_ERROR_TRY_AGAIN));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 7
    }
  }, i18n.PREVIEW_DESCRIPTION), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 7
    }
  }), entityTypes.map(entityType => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    key: entityType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(RiskScorePreviewPanel, {
    items: getRiskiestScores(data === null || data === void 0 ? void 0 : data.scores[entityType], _types.EntityTypeToIdentifierField[entityType]),
    showMessage: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.riskScore.riskScorePreview.show",
      defaultMessage: "Show {entityType}s",
      values: {
        entityType
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 219,
        columnNumber: 15
      }
    }),
    hideMessage: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.riskScore.riskScorePreview.hide",
      defaultMessage: "Hide {entityType}s",
      values: {
        entityType
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 228,
        columnNumber: 15
      }
    }),
    isLoading: isLoading,
    type: entityType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 11
    }
  }))));
};