"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useConfigurableRiskEngineSettings = void 0;
Object.defineProperty(exports, "useInvalidateRiskEngineSettingsQuery", {
  enumerable: true,
  get: function () {
    return _use_risk_engine_settings_query.useInvalidateRiskEngineSettingsQuery;
  }
});
Object.defineProperty(exports, "useRiskEngineSettingsMutations", {
  enumerable: true,
  get: function () {
    return _use_risk_engine_settings_mutations.useRiskEngineSettingsMutations;
  }
});
Object.defineProperty(exports, "useRiskEngineSettingsQuery", {
  enumerable: true,
  get: function () {
    return _use_risk_engine_settings_query.useRiskEngineSettingsQuery;
  }
});
Object.defineProperty(exports, "useRiskEngineSettingsState", {
  enumerable: true,
  get: function () {
    return _use_risk_engine_settings_state.useRiskEngineSettingsState;
  }
});
var _use_risk_engine_settings_query = require("./use_risk_engine_settings_query");
var _use_risk_engine_settings_mutations = require("./use_risk_engine_settings_mutations");
var _use_risk_engine_settings_state = require("./use_risk_engine_settings_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useConfigurableRiskEngineSettings = () => {
  const {
    savedRiskEngineSettings,
    isLoadingRiskEngineSettings,
    isError
  } = (0, _use_risk_engine_settings_query.useRiskEngineSettingsQuery)();
  const {
    selectedRiskEngineSettings,
    selectedSettingsMatchSavedSettings,
    resetSelectedSettings,
    setSelectedDateSetting,
    toggleSelectedClosedAlertsSetting,
    toggleScoreRetainment,
    setAlertFilters,
    getUIAlertFilters,
    waitingForSaveRefetch,
    preSaveFilterCount
  } = (0, _use_risk_engine_settings_state.useRiskEngineSettingsState)(savedRiskEngineSettings, isLoadingRiskEngineSettings, isError);
  const {
    saveSelectedSettingsMutation
  } = (0, _use_risk_engine_settings_mutations.useRiskEngineSettingsMutations)(savedRiskEngineSettings, waitingForSaveRefetch, preSaveFilterCount);
  return {
    savedRiskEngineSettings,
    selectedRiskEngineSettings,
    selectedSettingsMatchSavedSettings,
    resetSelectedSettings,
    setSelectedDateSetting,
    toggleSelectedClosedAlertsSetting,
    saveSelectedSettingsMutation,
    isLoadingRiskEngineSettings,
    toggleScoreRetainment,
    setAlertFilters,
    getUIAlertFilters
  };
};

// Re-export the individual hooks for direct use if needed
exports.useConfigurableRiskEngineSettings = useConfigurableRiskEngineSettings;