"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePrivilegedAccessDetectionIntegration = exports.useEntityAnalyticsIntegrations = void 0;
var _reactQuery = require("@kbn/react-query");
var _public = require("@kbn/fleet-plugin/public");
var _kibana_react = require("../../../../common/lib/kibana/kibana_react");
var _integrations_check_complete_helpers = require("../../../../onboarding/components/onboarding_body/cards/common/integrations/integrations_check_complete_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isGetInfoResponse = integration => integration !== undefined;
const buildPackageNamesQuery = packageNames => packageNames.length === 1 ? packageNames[0] : packageNames.map(name => `(${name})`).join(' OR ');
const useActiveEntityAnalyticsIntegrations = packageNames => {
  const services = (0, _kibana_react.useKibana)().services;
  return (0, _reactQuery.useQuery)(['entity-analytics-active-integrations', packageNames], async () => {
    return (0, _integrations_check_complete_helpers.getInstalledPackages)({
      showOnlyActiveDataStreams: true,
      nameQuery: buildPackageNamesQuery(packageNames)
    }, services);
  });
};
const OKTA_PACKAGE_NAME = 'entityanalytics_okta';
const AD_PACKAGE_NAME = 'entityanalytics_ad';
const useEntityAnalyticsIntegrations = () => {
  const {
    data: okta
  } = (0, _public.useGetPackageInfoByKeyQuery)(OKTA_PACKAGE_NAME, undefined,
  // When package version is undefined it gets the latest version
  undefined,
  // No options required
  {
    suspense: true // Make query suspend, it needs tu be wrapped by <Suspense />
  });
  const {
    data: ad
  } = (0, _public.useGetPackageInfoByKeyQuery)(AD_PACKAGE_NAME, undefined,
  // When package version is undefined it gets the latest version
  {
    prerelease: true // This is a technical preview package, delete this line when it is GA:  https://github.com/elastic/security-team/issues/15167
  }, {
    suspense: true
  });

  // We need to query the active integrations to check if the data streams are installed.
  // Unfortunately GetPackageInfo doesn't support 'showOnlyActiveDataStreams'
  const {
    data: activeIntegrationsResponse
  } = useActiveEntityAnalyticsIntegrations([OKTA_PACKAGE_NAME, AD_PACKAGE_NAME]);
  return [okta, ad].filter(isGetInfoResponse).map(({
    item: packageInfo
  }) => {
    const activeIntegration = activeIntegrationsResponse === null || activeIntegrationsResponse === void 0 ? void 0 : activeIntegrationsResponse.items.find(activePkg => activePkg.name === packageInfo.name);
    return {
      packageInfo,
      hasDataStreams: activeIntegration ? activeIntegration.dataStreams.length > 0 : false
    };
  });
};
exports.useEntityAnalyticsIntegrations = useEntityAnalyticsIntegrations;
const usePrivilegedAccessDetectionIntegration = () => {
  const {
    data: pad
  } = (0, _public.useGetPackageInfoByKeyQuery)('pad', undefined,
  // When package version is undefined it gets the latest version
  {
    prerelease: true // This is a technical preview package, delete this line when it is GA:  https://github.com/elastic/security-team/issues/15167
  }, {
    suspense: false
  });
  return isGetInfoResponse(pad) ? pad.item : undefined;
};
exports.usePrivilegedAccessDetectionIntegration = usePrivilegedAccessDetectionIntegration;