"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStopEntityEngineMutation = exports.useEntityStoreStatus = exports.useEnableEntityStoreMutation = exports.useDeleteEntityEngineMutation = exports.STOP_ENTITY_ENGINE_STATUS_KEY = exports.INIT_ENTITY_ENGINE_STATUS_KEY = exports.ENABLE_STORE_STATUS_KEY = exports.DELETE_ENTITY_ENGINE_STATUS_KEY = void 0;
var _reactQuery = require("@kbn/react-query");
var _kibana_react = require("../../../../common/lib/kibana/kibana_react");
var _entity_store = require("../../../api/entity_store");
var _telemetry = require("../../../../common/lib/telemetry");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ENTITY_STORE_STATUS = ['GET', 'ENTITY_STORE_STATUS'];
const useEntityStoreStatus = (opts = {}) => {
  const {
    getEntityStoreStatus
  } = (0, _entity_store.useEntityStoreRoutes)();
  return (0, _reactQuery.useQuery)({
    queryKey: [...ENTITY_STORE_STATUS, opts.withComponents],
    queryFn: () => getEntityStoreStatus(opts.withComponents),
    refetchInterval: data => {
      if ((data === null || data === void 0 ? void 0 : data.status) === 'installing') {
        return 5000;
      }
      return false;
    }
  });
};
exports.useEntityStoreStatus = useEntityStoreStatus;
const ENABLE_STORE_STATUS_KEY = exports.ENABLE_STORE_STATUS_KEY = ['POST', 'ENABLE_ENTITY_STORE'];
const useEnableEntityStoreMutation = options => {
  const {
    telemetry
  } = (0, _kibana_react.useKibana)().services;
  const queryClient = (0, _reactQuery.useQueryClient)();
  const {
    enableEntityStore
  } = (0, _entity_store.useEntityStoreRoutes)();
  return (0, _reactQuery.useMutation)(params => {
    telemetry === null || telemetry === void 0 ? void 0 : telemetry.reportEvent(_telemetry.EntityEventTypes.EntityStoreEnablementToggleClicked, {
      timestamp: new Date().toISOString(),
      action: 'start'
    });
    return enableEntityStore(params);
  }, {
    mutationKey: ENABLE_STORE_STATUS_KEY,
    onSuccess: () => queryClient.refetchQueries(ENTITY_STORE_STATUS),
    ...options
  });
};
exports.useEnableEntityStoreMutation = useEnableEntityStoreMutation;
const INIT_ENTITY_ENGINE_STATUS_KEY = exports.INIT_ENTITY_ENGINE_STATUS_KEY = ['POST', 'INIT_ENTITY_ENGINE'];
const STOP_ENTITY_ENGINE_STATUS_KEY = exports.STOP_ENTITY_ENGINE_STATUS_KEY = ['POST', 'STOP_ENTITY_ENGINE'];
const useStopEntityEngineMutation = entityTypes => {
  const {
    telemetry
  } = (0, _kibana_react.useKibana)().services;
  const queryClient = (0, _reactQuery.useQueryClient)();
  const {
    stopEntityEngine
  } = (0, _entity_store.useEntityStoreRoutes)();
  return (0, _reactQuery.useMutation)(() => {
    telemetry === null || telemetry === void 0 ? void 0 : telemetry.reportEvent(_telemetry.EntityEventTypes.EntityStoreEnablementToggleClicked, {
      timestamp: new Date().toISOString(),
      action: 'stop'
    });
    return Promise.all(entityTypes.map(entityType => stopEntityEngine(entityType)));
  }, {
    mutationKey: STOP_ENTITY_ENGINE_STATUS_KEY,
    onSuccess: () => queryClient.refetchQueries({
      queryKey: ENTITY_STORE_STATUS
    })
  });
};
exports.useStopEntityEngineMutation = useStopEntityEngineMutation;
const DELETE_ENTITY_ENGINE_STATUS_KEY = exports.DELETE_ENTITY_ENGINE_STATUS_KEY = ['POST', 'STOP_ENTITY_ENGINE'];
const useDeleteEntityEngineMutation = ({
  onSuccess,
  entityTypes
}) => {
  const queryClient = (0, _reactQuery.useQueryClient)();
  const {
    deleteEntityEngine
  } = (0, _entity_store.useEntityStoreRoutes)();
  return (0, _reactQuery.useMutation)(() => Promise.all(entityTypes.map(entityType => deleteEntityEngine(entityType, true))), {
    mutationKey: DELETE_ENTITY_ENGINE_STATUS_KEY,
    onSuccess: () => {
      queryClient.refetchQueries({
        queryKey: ENTITY_STORE_STATUS
      });
      onSuccess === null || onSuccess === void 0 ? void 0 : onSuccess();
    }
  });
};
exports.useDeleteEntityEngineMutation = useDeleteEntityEngineMutation;