"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntityHighlightsSettings = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _aiAssistantIcon = require("@kbn/ai-assistant-icon");
var _lodash = require("lodash");
var _elasticAssistant = require("@kbn/elastic-assistant");
var _fp = require("lodash/fp");
var _anonymization_settings_management = require("@kbn/elastic-assistant/impl/data_anonymization/settings/anonymization_settings_management");
var _react2 = require("@emotion/react");
var _use_agent_builder_availability = require("../../../../agent_builder/hooks/use_agent_builder_availability");
var _prompts = require("../../../../agent_builder/components/prompts");
var _new_agent_builder_attachment = require("../../../../agent_builder/components/new_agent_builder_attachment");
var _use_agent_builder_attachment = require("../../../../agent_builder/hooks/use_agent_builder_attachment");
var _use_ask_ai_assistant = require("../tabs/risk_inputs/use_ask_ai_assistant");
var _helpers = require("../utils/helpers");
var _constants = require("../../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/entity_details_flyout/components/entity_highlights_settings.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EntityHighlightsSettings = ({
  showAnonymizedValues,
  onChangeShowAnonymizedValues,
  setConnectorId,
  connectorId,
  connectorName,
  closePopover,
  openPopover,
  isLoading,
  isPopoverOpen,
  entityType,
  entityIdentifier,
  isAssistantVisible,
  assistantResult
}) => {
  const selectedConversationHasAnonymizedValues = (0, _react.useMemo)(() => !(0, _fp.isEmpty)(assistantResult === null || assistantResult === void 0 ? void 0 : assistantResult.replacements), [assistantResult === null || assistantResult === void 0 ? void 0 : assistantResult.replacements]);
  const anonymizedEntityIdentifier = (0, _react.useMemo)(() => assistantResult !== null && assistantResult !== void 0 && assistantResult.replacements ? (0, _helpers.getAnonymizedEntityIdentifier)(entityIdentifier, assistantResult.replacements) : entityIdentifier, [entityIdentifier, assistantResult === null || assistantResult === void 0 ? void 0 : assistantResult.replacements]);
  const [isAnonymizationModalVisible, setIsAnonymizationModalVisible] = (0, _react.useState)(false);
  const closeAnonymizationModal = (0, _react.useCallback)(() => setIsAnonymizationModalVisible(false), []);
  const showAnonymizationModal = (0, _react.useCallback)(() => setIsAnonymizationModalVisible(true), []);
  const getPromptContext = (0, _react.useCallback)(async () => `### The following entity is under investigation:\nType: ${entityType}\nIdentifier: ${`\`${anonymizedEntityIdentifier}\``}\n#### Context:\n\`\`\`json\n${assistantResult === null || assistantResult === void 0 ? void 0 : assistantResult.summaryAsText}`, [anonymizedEntityIdentifier, assistantResult === null || assistantResult === void 0 ? void 0 : assistantResult.summaryAsText, entityType]);
  const {
    showAssistantOverlay
  } = (0, _use_ask_ai_assistant.useAskAiAssistant)({
    title: `Investigating ${entityType} '${entityIdentifier}'`,
    description: `Entity: ${entityIdentifier}`,
    suggestedPrompt: `Investigate the entity and suggest next steps.`,
    getPromptContext,
    replacements: assistantResult === null || assistantResult === void 0 ? void 0 : assistantResult.replacements
  });
  const {
    isAgentBuilderEnabled
  } = (0, _use_agent_builder_availability.useAgentBuilderAvailability)();
  const entityAttachment = (0, _react.useMemo)(() => ({
    attachmentType: _constants.SecurityAgentBuilderAttachments.entity,
    attachmentData: {
      identifierType: entityType,
      identifier: entityIdentifier,
      attachmentLabel: `${entityType}: ${entityIdentifier}`
    },
    attachmentPrompt: _prompts.ENTITY_PROMPT
  }), [entityIdentifier, entityType]);
  const {
    openAgentBuilderFlyout
  } = (0, _use_agent_builder_attachment.useAgentBuilderAttachment)(entityAttachment);
  const onAgentBuildAttachmentClick = (0, _react.useCallback)(() => {
    openAgentBuilderFlyout();
    closePopover();
  }, [closePopover, openAgentBuilderFlyout]);
  const panels = (0, _react.useMemo)(() => [{
    id: 0,
    items: [{
      name: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        alignItems: "center",
        justifyContent: "spaceBetween",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 133,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 134,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.flyout.entityDetails.highlights.connectorMenuTitle",
        defaultMessage: "Connector",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 135,
          columnNumber: 19
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 140,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 141,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 142,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextTruncate, {
        text: connectorName,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 143,
          columnNumber: 23
        }
      }))))),
      icon: 'plugs',
      panel: 2,
      key: 'entity-highlights-settings-connector',
      'data-test-subj': 'entity-highlights-settings-connector'
    }, {
      key: 'entity-highlights-settings-options-title',
      renderItem: () => /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
        paddingSize: "s",
        "aria-label": _i18n.i18n.translate('xpack.securitySolution.flyout.entityDetails.highlights.optionsMenuTitle.ariaLabel', {
          defaultMessage: 'Options'
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 157,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 166,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 167,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.flyout.entityDetails.highlights.optionsMenuTitle",
        defaultMessage: "Options",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 168,
          columnNumber: 21
        }
      }))))
    }, {
      key: 'anonymize-values',
      renderItem: () => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        "aria-label": _i18n.i18n.translate('xpack.securitySolution.flyout.entityDetails.highlights.anonymizeValuesAriaLabel', {
          defaultMessage: 'Show anonymized values'
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 180,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "row",
        gutterSize: "s",
        alignItems: "center",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 188,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 189,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        "data-test-subj": "anonymizationGroup",
        gutterSize: "s",
        responsive: false,
        wrap: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 190,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 197,
          columnNumber: 23
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
        label: _i18n.i18n.translate('xpack.securitySolution.flyout.entityDetails.highlights.showAnonymizedValues', {
          defaultMessage: 'Show anonymized values'
        }),
        checked: showAnonymizedValues,
        onChange: onChangeShowAnonymizedValues,
        compressed: true,
        disabled: !selectedConversationHasAnonymizedValues,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 198,
          columnNumber: 25
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 212,
          columnNumber: 23
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        "aria-label": _i18n.i18n.translate('xpack.securitySolution.flyout.entityDetails.highlights.anonymizationArialLabel', {
          defaultMessage: 'Anonymization'
        }),
        "data-test-subj": "anonymizationSettings",
        iconType: "gear",
        onClick: showAnonymizationModal,
        size: "s",
        color: "text",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 213,
          columnNumber: 25
        }
      }))))))
    }, {
      key: 'ask-ai-assistant',
      renderItem: () => {
        if (isAgentBuilderEnabled) {
          return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
            "aria-label": _i18n.i18n.translate('xpack.securitySolution.flyout.entityDetails.highlights.askAiAssistantAriaLabel', {
              defaultMessage: 'Ask AI Assistant'
            }),
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 238,
              columnNumber: 19
            }
          }, /*#__PURE__*/_react.default.createElement(_new_agent_builder_attachment.NewAgentBuilderAttachment, {
            onClick: onAgentBuildAttachmentClick,
            size: "s",
            disabled: isLoading || !assistantResult,
            telemetry: {
              pathway: 'entity_highlights',
              attachments: ['entity']
            },
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 246,
              columnNumber: 21
            }
          }));
        }
        if (!isAssistantVisible) return null;
        return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
          "aria-label": _i18n.i18n.translate('xpack.securitySolution.flyout.entityDetails.highlights.askAiAssistantAriaLabel', {
            defaultMessage: 'Ask AI Assistant'
          }),
          onClick: () => {
            showAssistantOverlay();
            closePopover();
          },
          icon: /*#__PURE__*/_react.default.createElement(_aiAssistantIcon.AssistantIcon, {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 273,
              columnNumber: 25
            }
          }),
          disabled: isLoading || !assistantResult,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 262,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.flyout.entityDetails.highlights.askAiAssistant",
          defaultMessage: "Ask AI Assistant",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 276,
            columnNumber: 19
          }
        }));
      }
    }]
  }, {
    id: 2,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.entityDetails.highlights.connectorMenuTitle",
      defaultMessage: "Connector",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 289,
        columnNumber: 11
      }
    }),
    items: [{
      key: 'entity-highlights-settings-connector-selector',
      renderItem: () => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        "aria-label": _i18n.i18n.translate('xpack.securitySolution.flyout.entityDetails.highlights.connectorSelectorAriaLabel', {
          defaultMessage: 'Connector selector'
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 298,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_elasticAssistant.ConnectorSelectorInline, {
        onConnectorSelected: _lodash.noop,
        onConnectorIdSelected: setConnectorId,
        selectedConnectorId: connectorId,
        explicitConnectorSelection: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 306,
          columnNumber: 17
        }
      }))
    }]
  }], [connectorName, showAnonymizedValues, onChangeShowAnonymizedValues, selectedConversationHasAnonymizedValues, onAgentBuildAttachmentClick, isAssistantVisible, setConnectorId, connectorId, showAssistantOverlay, closePopover, isAgentBuilderEnabled, isLoading, assistantResult, showAnonymizationModal]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": _i18n.i18n.translate('xpack.securitySolution.flyout.entityDetails.highlights.openMenuAriaLabel', {
        defaultMessage: 'Entity highlights settings menu'
      }),
      iconType: "boxesVertical",
      onClick: openPopover,
      disabled: isLoading,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 339,
        columnNumber: 9
      }
    }),
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "leftUp",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 337,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    css: (0, _react2.css)`
          width: 280px;
        `,
    initialPanelId: 0,
    size: "m",
    panels: panels,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 356,
      columnNumber: 7
    }
  }), isAnonymizationModalVisible && /*#__PURE__*/_react.default.createElement(_anonymization_settings_management.AnonymizationSettingsManagement, {
    modalMode: true,
    onClose: closeAnonymizationModal,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 365,
      columnNumber: 9
    }
  }));
};
exports.EntityHighlightsSettings = EntityHighlightsSettings;